﻿<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>UTM Builder for GoHighLevel | Campaign Tracking URL Generator | Free GHL Tool</title>
    <meta name="description" content="Free UTM builder for GoHighLevel users and agencies. Create tracking URLs for marketing campaigns, track performance, and optimize your GHL marketing efforts with proper attribution.">
    <meta name="keywords" content="UTM builder, campaign tracking, URL parameters, GoHighLevel UTM tool, marketing attribution, campaign tracking URLs, UTM parameters">
    <meta name="author" content="Paddle CRM">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="UTM Builder for GoHighLevel | Campaign Tracking URL Generator">
    <meta property="og:description" content="Free UTM builder for GoHighLevel users. Create tracking URLs for marketing campaigns.">
    <meta property="og:url" content="https://yourdomain.com/utm-builder.php">
    <meta property="og:image" content="https://yourdomain.com/images/utm-builder-og.jpg">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="UTM Builder for GoHighLevel | Campaign Tracking URL Generator">
    <meta property="twitter:description" content="Free UTM builder for GoHighLevel users. Create tracking URLs for marketing campaigns.">
    <meta property="twitter:image" content="https://yourdomain.com/images/utm-builder-og.jpg">
    
    <!-- Schema.org structured data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "UTM Builder for GoHighLevel",
        "description": "Free UTM parameter builder tool for GoHighLevel marketing campaign tracking",
        "url": "https://yourdomain.com/utm-builder.php",
        "applicationCategory": "BusinessApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Paddle CRM",
            "description": "WhiteLabel GoHighLevel Agency"
        }
    }
    </script>
    
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php inc('includes/header.php'); ?>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <nav class="breadcrumb">
                <a href="index.php">Home</a> > <span>UTM Builder</span>
            </nav>
            <h1>UTM Builder for GoHighLevel Marketing Campaigns</h1>
            <p class="hero-subtitle">Create tracking URLs for your marketing campaigns, track performance, and optimize your GHL marketing efforts with proper attribution</p>
        </div>
    </section>

    <!-- Tool Section -->
    <section class="tool-section">
        <div class="container">
            <div class="tool-card featured">
                <div class="tool-icon">🔗</div>
                <h2>Professional UTM URL Builder</h2>
                <p>Advanced UTM parameter builder designed specifically for GoHighLevel users and agencies</p>
                
                <div class="tool-interface">
                    <div class="utm-form">
                        <div class="input-group">
                            <label for="baseUrl">Base URL *</label>
                            <input type="url" id="baseUrl" placeholder="https://yourdomain.com/landing-page" required>
                        </div>
                        
                        <div class="input-row">
                            <div class="input-group">
                                <label for="utmSource">UTM Source *</label>
                                <input type="text" id="utmSource" placeholder="google, facebook, email, etc." required>
                            </div>
                            <div class="input-group">
                                <label for="utmMedium">UTM Medium *</label>
                                <input type="text" id="utmMedium" placeholder="cpc, social, email, etc." required>
                            </div>
                        </div>
                        
                        <div class="input-row">
                            <div class="input-group">
                                <label for="utmCampaign">UTM Campaign *</label>
                                <input type="text" id="utmCampaign" placeholder="summer_sale_2024" required>
                            </div>
                            <div class="input-group">
                                <label for="utmTerm">UTM Term</label>
                                <input type="text" id="utmTerm" placeholder="keyword or search term">
                            </div>
                        </div>
                        
                        <div class="input-group">
                            <label for="utmContent">UTM Content</label>
                            <input type="text" id="utmContent" placeholder="banner_ad, text_link, etc.">
                        </div>
                        
                        <button class="btn" onclick="generateUTM()">Generate UTM URL</button>
                    </div>
                    
                    <div class="utm-results" id="utmResults" style="display: none;">
                        <h4>Generated UTM URL</h4>
                        <div class="url-display">
                            <div class="generated-url" id="generatedUrl"></div>
                            <button class="btn btn-secondary" onclick="copyUTM()">Copy URL</button>
                        </div>
                        
                        <div class="utm-breakdown">
                            <h5>URL Breakdown</h5>
                            <div class="breakdown-grid">
                                <div class="breakdown-item">
                                    <span class="breakdown-label">Base URL:</span>
                                    <span id="breakdownBase" class="breakdown-value"></span>
                                </div>
                                <div class="breakdown-item">
                                    <span class="breakdown-label">Source:</span>
                                    <span id="breakdownSource" class="breakdown-value"></span>
                                </div>
                                <div class="breakdown-item">
                                    <span class="breakdown-label">Medium:</span>
                                    <span id="breakdownMedium" class="breakdown-value"></span>
                                </div>
                                <div class="breakdown-item">
                                    <span class="breakdown-label">Campaign:</span>
                                    <span id="breakdownCampaign" class="breakdown-value"></span>
                                </div>
                                <div class="breakdown-item">
                                    <span class="breakdown-label">Term:</span>
                                    <span id="breakdownTerm" class="breakdown-value"></span>
                                </div>
                                <div class="breakdown-item">
                                    <span class="breakdown-label">Content:</span>
                                    <span id="breakdownContent" class="breakdown-value"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Content Section -->
    <section class="content-section">
        <div class="container">
            <div class="content-grid">
                <article class="content-card">
                    <h2>What are UTM Parameters?</h2>
                    <p>UTM (Urchin Tracking Module) parameters are tags you add to URLs to track the effectiveness of your marketing campaigns across traffic sources and publishing media. They help you understand which marketing efforts are driving traffic and conversions to your website.</p>
                    
                    <p>In the context of GoHighLevel marketing campaigns, UTM parameters become essential for tracking the performance of different marketing channels, campaigns, and content pieces, allowing you to make data-driven decisions about your marketing investments.</p>
                    
                    <h3>Core UTM Parameters</h3>
                    <ul>
                        <li><strong>utm_source:</strong> Identifies the site that sent the traffic (e.g., google, facebook, newsletter)</li>
                        <li><strong>utm_medium:</strong> Identifies the marketing medium (e.g., cpc, social, email)</li>
                        <li><strong>utm_campaign:</strong> Identifies a specific product promotion or strategic campaign</li>
                        <li><strong>utm_term:</strong> Identifies paid search keywords (mainly for paid search)</li>
                        <li><strong>utm_content:</strong> Identifies what specifically was clicked (e.g., banner, text link)</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Why GoHighLevel Users Need UTM Tracking</h2>
                    <p>GoHighLevel provides excellent marketing automation tools, but without proper UTM tracking, you're missing crucial insights into your campaign performance. This tool helps you:</p>
                    
                    <ul>
                        <li><strong>Track campaign performance</strong> across different marketing channels</li>
                        <li><strong>Measure ROI</strong> for specific marketing initiatives</li>
                        <li><strong>Optimize marketing spend</strong> based on actual performance data</li>
                        <li><strong>Understand customer journey</strong> and attribution across touchpoints</li>
                        <li><strong>Improve conversion rates</strong> by identifying high-performing traffic sources</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>How to Use the UTM Builder Tool</h2>
                    <ol>
                        <li><strong>Enter your base URL:</strong> The landing page or destination URL you want to track</li>
                        <li><strong>Set UTM Source:</strong> Identify where the traffic is coming from (e.g., google, facebook)</li>
                        <li><strong>Choose UTM Medium:</strong> Specify the marketing channel (e.g., cpc, social, email)</li>
                        <li><strong>Name your campaign:</strong> Create a unique identifier for your marketing campaign</li>
                        <li><strong>Add optional parameters:</strong> Include terms and content for more detailed tracking</li>
                        <li><strong>Generate and copy:</strong> Get your tracking URL and use it in your marketing</li>
                    </ol>
                    
                    <h3>UTM Best Practices</h3>
                    <ul>
                        <li>Use lowercase letters and underscores for spaces</li>
                        <li>Be consistent with your naming conventions</li>
                        <li>Keep UTM parameters short and descriptive</li>
                        <li>Test your URLs before launching campaigns</li>
                        <li>Document your UTM structure for team consistency</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Use Cases for GoHighLevel Agencies</h2>
                    <h3>Multi-Channel Campaign Tracking</h3>
                    <p>Track the performance of campaigns across multiple channels (social media, email, paid ads, organic search) to understand which channels deliver the best ROI for your clients.</p>
                    
                    <h3>Client Campaign Attribution</h3>
                    <p>Provide clients with detailed reports showing exactly which marketing activities are driving leads and conversions, helping justify marketing investments.</p>
                    
                    <h3>Funnel Performance Analysis</h3>
                    <p>Use UTM tracking to understand how different traffic sources perform at each stage of your GoHighLevel funnels, from awareness to conversion.</p>
                    
                    <h3>A/B Testing and Optimization</h3>
                    <p>Track different versions of campaigns, ads, or content pieces to identify what resonates best with your target audience.</p>
                </article>

                <article class="content-card">
                    <h2>UTM Parameter Best Practices</h2>
                    <h3>Source Naming Conventions</h3>
                    <ul>
                        <li><strong>Search Engines:</strong> google, bing, yahoo</li>
                        <li><strong>Social Platforms:</strong> facebook, instagram, linkedin, twitter</li>
                        <li><strong>Email Marketing:</strong> newsletter, email, drip</li>
                        <li><strong>Referral Sites:</strong> partner_name, affiliate_name</li>
                        <li><strong>Direct Traffic:</strong> direct, bookmark</li>
                    </ul>
                    
                    <h3>Medium Naming Conventions</h3>
                    <ul>
                        <li><strong>Paid Search:</strong> cpc, ppc, paid-search</li>
                        <li><strong>Social Media:</strong> social, social-media</li>
                        <li><strong>Email Marketing:</strong> email, email-marketing</li>
                        <li><strong>Display Advertising:</strong> display, banner</li>
                        <li><strong>Organic Traffic:</strong> organic, seo</li>
                    </ul>
                    
                    <h3>Campaign Naming Conventions</h3>
                    <ul>
                        <li><strong>Seasonal Campaigns:</strong> summer_sale_2024, holiday_promotion</li>
                        <li><strong>Product Launches:</strong> new_product_launch, feature_release</li>
                        <li><strong>Promotional Events:</strong> black_friday, cyber_monday</li>
                        <li><strong>Content Marketing:</strong> ebook_launch, webinar_promotion</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Integration with GoHighLevel Analytics</h2>
                    <p>This UTM builder tool integrates seamlessly with your GoHighLevel analytics and tracking:</p>
                    
                    <h3>Traffic Source Analysis</h3>
                    <p>Use UTM parameters to segment your GoHighLevel analytics by traffic source, medium, and campaign, giving you detailed insights into performance.</p>
                    
                    <h3>Lead Attribution Tracking</h3>
                    <p>Track which UTM parameters are generating the highest quality leads in your GoHighLevel CRM, allowing you to optimize your marketing mix.</p>
                    
                    <h3>Automation Triggers</h3>
                    <p>Set up GoHighLevel automation sequences based on UTM parameters, creating personalized experiences for visitors from different campaigns.</p>
                    
                    <h3>ROI Calculation</h3>
                    <p>Calculate the ROI of specific campaigns by tracking UTM-generated leads through your entire GoHighLevel sales funnel.</p>
                </article>

                <article class="content-card">
                    <h2>Advanced UTM Tracking Strategies</h2>
                    <h3>Multi-Touch Attribution</h3>
                    <p>Implement UTM tracking across multiple touchpoints to understand the full customer journey and optimize your marketing mix accordingly.</p>
                    
                    <h3>Dynamic UTM Parameters</h3>
                    <p>Use dynamic UTM parameters that automatically populate based on the traffic source, reducing manual work and ensuring consistency.</p>
                    
                    <h3>UTM Parameter Validation</h3>
                    <p>Regularly audit your UTM parameters to ensure they're working correctly and providing accurate tracking data.</p>
                    
                    <h3>Cross-Platform Tracking</h3>
                    <p>Extend UTM tracking beyond web traffic to include mobile apps, social media platforms, and other digital touchpoints.</p>
                </article>

                <article class="content-card">
                    <h2>Industry Standards and Benchmarks</h2>
                    <p>Understanding industry standards helps you benchmark your UTM tracking performance:</p>
                    
                    <h3>UTM Parameter Usage Statistics</h3>
                    <ul>
                        <li><strong>Source Tracking:</strong> 85% of marketers track traffic sources</li>
                        <li><strong>Medium Tracking:</strong> 78% track marketing mediums</li>
                        <li><strong>Campaign Tracking:</strong> 72% track specific campaigns</li>
                        <li><strong>Content Tracking:</strong> 65% track content variations</li>
                        <li><strong>Term Tracking:</strong> 58% track search terms (mainly PPC)</li>
                    </ul>
                    
                    <h3>GoHighLevel Specific</h3>
                    <p>GoHighLevel users who implement proper UTM tracking typically see 30-50% improvement in campaign attribution accuracy and 20-35% better ROI optimization due to improved data insights.</p>
                </article>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="related-tools">
        <div class="container">
            <h2>Related GoHighLevel Tools</h2>
            <div class="tools-grid">
                <a href="roi-calculator.php" class="tool-link">
                    <div class="tool-icon">💰</div>
                    <h3>ROI Calculator</h3>
                    <p>Calculate marketing campaign returns and optimize investments</p>
                </a>
                <a href="lead-scoring.php" class="tool-link">
                    <div class="tool-icon">🎯</div>
                    <h3>Lead Scoring Tool</h3>
                    <p>Score and prioritize your leads for better conversion</p>
                </a>
                <a href="funnel-calculator.php" class="tool-link">
                    <div class="tool-icon">🔄</div>
                    <h3>Funnel Calculator</h3>
                    <p>Analyze funnel performance and conversion rates</p>
                </a>
            </div>
        </div>
    </section>

    <?php inc('includes/footer.php'); ?>
    <script src="common.js"></script>
    <script>`n    `n    // Load footer`n    fetch("footer.php")`n        .then(response => response.text())`n        .then(data => {`n            document.getElementById("footer-placeholder").innerHTML = data;`n        });`n});`n`n
        function generateUTM() {
            const baseUrl = document.getElementById('baseUrl').value.trim();
            const utmSource = document.getElementById('utmSource').value.trim();
            const utmMedium = document.getElementById('utmMedium').value.trim();
            const utmCampaign = document.getElementById('utmCampaign').value.trim();
            const utmTerm = document.getElementById('utmTerm').value.trim();
            const utmContent = document.getElementById('utmContent').value.trim();
            
            if (!baseUrl || !utmSource || !utmMedium || !utmCampaign) {
                alert('Please fill in all required fields (Base URL, Source, Medium, and Campaign)');
                return;
            }
            
            // Build UTM URL
            let utmUrl = baseUrl;
            const params = new URLSearchParams();
            
            params.append('utm_source', utmSource);
            params.append('utm_medium', utmMedium);
            params.append('utm_campaign', utmCampaign);
            
            if (utmTerm) {
                params.append('utm_term', utmTerm);
            }
            if (utmContent) {
                params.append('utm_content', utmContent);
            }
            
            utmUrl += '?' + params.toString();
            
            // Display results
            document.getElementById('generatedUrl').textContent = utmUrl;
            document.getElementById('breakdownBase').textContent = baseUrl;
            document.getElementById('breakdownSource').textContent = utmSource;
            document.getElementById('breakdownMedium').textContent = utmMedium;
            document.getElementById('breakdownCampaign').textContent = utmCampaign;
            document.getElementById('breakdownTerm').textContent = utmTerm || 'Not specified';
            document.getElementById('breakdownContent').textContent = utmContent || 'Not specified';
            
            // Show results
            document.getElementById('utmResults').style.display = 'block';
        }
        
        function copyUTM() {
            const utmUrl = document.getElementById('generatedUrl').textContent;
            navigator.clipboard.writeText(utmUrl).then(function() {
                alert('UTM URL copied to clipboard!');
            }).catch(function(err) {
                // Fallback for older browsers
                const textArea = document.createElement('textarea');
                textArea.value = utmUrl;
                document.body.appendChild(textArea);
                textArea.select();
                document.execCommand('copy');
                document.body.removeChild(textArea);
                alert('UTM URL copied to clipboard!');
            });
        }
    </script>
</body>
</html>




