﻿<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Text Case Converter for GoHighLevel | Free Text Formatting Tool</title>
    <meta name="description" content="Free text case converter for GoHighLevel users. Convert text between uppercase, lowercase, title case, and sentence case. Perfect for content optimization and email marketing campaigns.">
    <meta name="keywords" content="text case converter, case converter, text formatting, uppercase, lowercase, title case, sentence case, GoHighLevel tool, content optimization, text formatting tool">
    <meta name="author" content="Paddle CRM">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="Text Case Converter for GoHighLevel">
    <meta property="og:description" content="Free text case converter for GoHighLevel users. Convert text between different cases for better content formatting.">
    <meta property="og:url" content="https://yourdomain.com/text-case-converter.php">
    <meta property="og:image" content="https://yourdomain.com/images/text-case-converter-og.jpg">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="Text Case Converter for GoHighLevel">
    <meta property="twitter:description" content="Free text case converter for GoHighLevel users. Convert text between different cases for better content formatting.">
    <meta property="twitter:image" content="https://yourdomain.com/images/text-case-converter-og.jpg">
    
    <!-- Schema.org structured data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Text Case Converter for GoHighLevel",
        "description": "Free tool to convert text between different cases for content optimization and formatting",
        "url": "https://yourdomain.com/text-case-converter.php",
        "applicationCategory": "BusinessApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Paddle CRM",
            "description": "WhiteLabel GoHighLevel Agency"
        }
    }
    </script>
    
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php inc('includes/header.php'); ?>

    <!-- Hero Section -->
    <section class="hero tool-hero">
        <div class="container">
            <nav class="breadcrumb">
                <a href="index.php">Home</a> > <span>Text Case Converter</span>
            </nav>
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">Text Case Converter for GoHighLevel</h1>
                    <p class="hero-subtitle">Convert text between different cases for better content formatting and optimization</p>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <span class="stat-number">Professional</span>
                            <span class="stat-label">Quality</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">GoHighLevel</span>
                            <span class="stat-label">Optimized</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Free Tool</span>
                        </div>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-image">
                        <div class="floating-card card-1">
                            <span class="card-icon">🔤</span>
                            <span class="card-text">Text</span>
                        </div>
                        <div class="floating-card card-2">
                            <span class="card-icon">⚡</span>
                            <span class="card-text">Fast</span>
                        </div>
                        <div class="floating-card card-3">
                            <span class="card-icon">🎯</span>
                            <span class="card-text">Formatted</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Section -->
    <section class="tool-section">
        <div class="container">
            <div class="tool-card featured">
                <div class="tool-icon">🔤</div>
                <h2>Text Case Converter</h2>
                <p>Professional text formatting tool designed specifically for GoHighLevel users and agencies</p>
                
                <div class="tool-interface">
                    <div class="input-group">
                        <label for="textInput">Enter Your Text</label>
                        <textarea id="textInput" rows="6" placeholder="Type or paste your text here to convert between different cases..."></textarea>
                    </div>
                    
                    <div class="button-group">
                        <button class="btn btn-primary" onclick="convertCase('upper')">UPPERCASE</button>
                        <button class="btn btn-secondary" onclick="convertCase('lower')">lowercase</button>
                        <button class="btn btn-secondary" onclick="convertCase('title')">Title Case</button>
                        <button class="btn btn-secondary" onclick="convertCase('sentence')">Sentence case</button>
                    </div>
                    
                    <div class="result" id="textResult" style="display: none;"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Content Section -->
    <section class="content-section">
        <div class="container">
            <div class="content-grid">
                <article class="content-card">
                    <h2>What is Text Case Conversion?</h2>
                    <p>Text case conversion is the process of transforming text between different capitalization formats. This includes converting text to uppercase (ALL CAPS), lowercase (all lowercase), title case (Each Word Capitalized), and sentence case (First letter capitalized).</p>
                    
                    <p>For GoHighLevel users, proper text formatting is crucial for:</p>
                    <ul>
                        <li><strong>Email Marketing:</strong> Creating professional subject lines and content</li>
                        <li><strong>Social Media:</strong> Maintaining consistent brand voice across platforms</li>
                        <li><strong>Content Creation:</strong> Ensuring proper formatting for blogs and landing pages</li>
                        <li><strong>Client Communication:</strong> Professional email and message formatting</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Why GoHighLevel Users Need This Tool</h2>
                    <p>As a GoHighLevel agency or user, you're constantly creating content for multiple clients across various platforms. Consistent text formatting is essential for maintaining professional standards and brand consistency.</p>
                    
                    <ul>
                        <li><strong>Time Efficiency:</strong> Convert text cases instantly instead of manually retyping</li>
                        <li><strong>Brand Consistency:</strong> Maintain uniform formatting across all client communications</li>
                        <li><strong>Professional Appearance:</strong> Ensure all content meets professional standards</li>
                        <li><strong>Multi-Platform Support:</strong> Format text for emails, social media, websites, and more</li>
                        <li><strong>Client Satisfaction:</strong> Deliver perfectly formatted content every time</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>How to Use the Text Case Converter</h2>
                    <p>Our text case converter is designed to be simple and efficient:</p>
                    
                    <ol>
                        <li><strong>Input Your Text:</strong> Paste or type the text you want to convert in the text area</li>
                        <li><strong>Choose Your Case:</strong> Select from four conversion options:
                            <ul>
                                <li><strong>UPPERCASE:</strong> Converts all text to capital letters</li>
                                <li><strong>lowercase:</strong> Converts all text to small letters</li>
                                <li><strong>Title Case:</strong> Capitalizes the first letter of each word</li>
                                <li><strong>Sentence case:</strong> Capitalizes only the first letter of the sentence</li>
                            </ul>
                        </li>
                        <li><strong>Copy Results:</strong> Use the copy button to easily copy your converted text</li>
                        <li><strong>Apply to Content:</strong> Paste the formatted text into your GoHighLevel campaigns</li>
                    </ol>
                </article>

                <article class="content-card">
                    <h2>Use Cases for GoHighLevel Agencies</h2>
                    <p>This tool serves multiple purposes in your daily GoHighLevel operations:</p>
                    
                    <ul>
                        <li><strong>Email Campaigns:</strong> Format subject lines, headers, and content consistently</li>
                        <li><strong>Social Media Management:</strong> Maintain proper case formatting across all platforms</li>
                        <li><strong>Landing Page Content:</strong> Ensure proper heading and text formatting</li>
                        <li><strong>Client Communications:</strong> Format professional emails and messages</li>
                        <li><strong>Content Creation:</strong> Prepare blog posts and articles with proper formatting</li>
                        <li><strong>Brand Guidelines:</strong> Maintain consistent text formatting across all client work</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Best Practices & Tips</h2>
                    <p>To get the most out of text case conversion in your GoHighLevel workflow:</p>
                    
                    <ul>
                        <li><strong>Subject Lines:</strong> Use title case for email subject lines to improve open rates</li>
                        <li><strong>Social Media:</strong> Maintain consistent formatting across all client accounts</li>
                        <li><strong>Brand Names:</strong> Always check proper brand name capitalization</li>
                        <li><strong>Content Review:</strong> Use the tool to review and format all client content</li>
                        <li><strong>Template Creation:</strong> Create properly formatted templates for consistent use</li>
                        <li><strong>Quality Control:</strong> Ensure all outgoing content meets formatting standards</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Integration with GoHighLevel</h2>
                    <p>This tool integrates seamlessly with your GoHighLevel workflow:</p>
                    
                    <ul>
                        <li><strong>Pre-campaign preparation:</strong> Format all text content before adding to GHL campaigns</li>
                        <li><strong>Template creation:</strong> Create properly formatted templates in GoHighLevel</li>
                        <li><strong>Content review:</strong> Use the tool to review and format client content before publishing</li>
                        <li><strong>Brand consistency:</strong> Maintain uniform formatting across all GHL funnels and campaigns</li>
                        <li><strong>Client deliverables:</strong> Ensure all client content meets professional formatting standards</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Industry Standards for Text Formatting</h2>
                    <p>Understanding proper text formatting standards helps you deliver professional content:</p>
                    
                    <ul>
                        <li><strong>Email Subject Lines:</strong> Title case is preferred for better readability and professionalism</li>
                        <li><strong>Social Media Posts:</strong> Sentence case is often more natural and engaging</li>
                        <li><strong>Website Headers:</strong> Title case for main headings, sentence case for subheadings</li>
                        <li><strong>Business Communications:</strong> Sentence case for body text, title case for emphasis</li>
                        <li><strong>Marketing Materials:</strong> Consistent formatting across all brand touchpoints</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Advanced Text Formatting Strategies</h2>
                    <p>Beyond basic case conversion, consider these advanced formatting strategies:</p>
                    
                    <ul>
                        <li><strong>Mixed Case Usage:</strong> Combine different cases for visual hierarchy and emphasis</li>
                        <li><strong>Brand Consistency:</strong> Develop and maintain brand-specific formatting guidelines</li>
                        <li><strong>Platform Optimization:</strong> Adapt formatting for different platforms and audiences</li>
                        <li><strong>Accessibility:</strong> Ensure formatting doesn't compromise readability</li>
                        <li><strong>Testing:</strong> A/B test different formatting approaches for better engagement</li>
                    </ul>
                </article>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="related-tools">
        <div class="container">
            <h2>Related GoHighLevel Tools</h2>
            <div class="tools-grid">
                <a href="content-readability-scorer.php" class="tool-link">
                    <div class="tool-icon">📖</div>
                    <h3>Content Readability Scorer</h3>
                    <p>Analyze and improve your content readability</p>
                </a>
                <a href="email-subject-line-scorer.php" class="tool-link">
                    <div class="tool-icon">📧</div>
                    <h3>Email Subject Line Scorer</h3>
                    <p>Optimize your email subject lines for better open rates</p>
                </a>
                <a href="keyword-density-checker.php" class="tool-link">
                    <div class="tool-icon">🔍</div>
                    <h3>Keyword Density Checker</h3>
                    <p>Analyze keyword usage in your content</p>
                </a>
            </div>
        </div>
    </section>

    <?php inc('includes/footer.php'); ?>
    <script src="common.js"></script>
    <script>`n    `n    // Load footer`n    fetch("footer.php")`n        .then(response => response.text())`n        .then(data => {`n            document.getElementById("footer-placeholder").innerHTML = data;`n        });`n});`n`n
        // Text Case Converter functionality
        function convertCase(type) {
            const text = document.getElementById('textInput').value;
            if (!text) {
                alert('Please enter some text');
                return;
            }
            
            let converted;
            let caseName;
            
            switch(type) {
                case 'upper':
                    converted = text.toUpperCase();
                    caseName = 'UPPERCASE';
                    break;
                case 'lower':
                    converted = text.toLowerCase();
                    caseName = 'lowercase';
                    break;
                case 'title':
                    converted = text.replace(/\w\S*/g, (txt) => txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase());
                    caseName = 'Title Case';
                    break;
                case 'sentence':
                    converted = text.charAt(0).toUpperCase() + text.slice(1).toLowerCase();
                    caseName = 'Sentence case';
                    break;
            }
            
            document.getElementById('textResult').innerHTML = `
                <h3>${caseName} Result:</h3>
                <div class="converted-text">${converted}</div>
                <button class="btn btn-primary" onclick="copyToClipboard('${converted}')">Copy Text</button>
            `;
            document.getElementById('textResult').style.display = 'block';
        }

        // Copy to clipboard functionality
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                // Change button text temporarily to show success
                const button = event.target;
                const originalText = button.textContent;
                button.textContent = 'Copied!';
                button.style.background = '#28a745';
                
                setTimeout(() => {
                    button.textContent = originalText;
                    button.style.background = '';
                }, 2000);
            }).catch(function(err) {
                console.error('Could not copy text: ', err);
                alert('Failed to copy text. Please select and copy manually.');
            });
        }

        // Auto-resize textarea
        document.getElementById('textInput').addEventListener('input', function() {
            this.style.height = 'auto';
            this.style.height = (this.scrollHeight) + 'px';
        });
    </script>
</body>
</html>




