﻿<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Social Media Caption Generator for GoHighLevel | Free Content Tool</title>
    <meta name="description" content="Free social media caption generator for GoHighLevel users. Create engaging captions for Instagram, Facebook, LinkedIn, and Twitter. Perfect for agencies managing social media campaigns.">
    <meta name="keywords" content="social media caption generator, Instagram captions, Facebook posts, LinkedIn content, Twitter posts, social media content, GoHighLevel agency, caption generator, social media marketing">
    <meta name="author" content="Paddle CRM">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="Social Media Caption Generator for GoHighLevel">
    <meta property="og:description" content="Free social media caption generator for GoHighLevel users. Create engaging captions for all platforms.">
    <meta property="og:url" content="https://yourdomain.com/social-media-caption-generator.php">
    <meta property="og:image" content="https://yourdomain.com/images/social-media-caption-generator-og.jpg">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="Social Media Caption Generator for GoHighLevel">
    <meta property="twitter:description" content="Free social media caption generator for GoHighLevel users. Create engaging captions for all platforms.">
    <meta property="twitter:image" content="https://yourdomain.com/images/social-media-caption-generator-og.jpg">
    
    <!-- Schema.org structured data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Social Media Caption Generator for GoHighLevel",
        "description": "Free tool to generate engaging social media captions for Instagram, Facebook, LinkedIn, and Twitter",
        "url": "https://yourdomain.com/social-media-caption-generator.php",
        "applicationCategory": "BusinessApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Paddle CRM",
            "description": "WhiteLabel GoHighLevel Agency"
        }
    }
    </script>
    
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php inc('includes/header.php'); ?>

    <!-- Hero Section -->
    <section class="hero tool-hero">
        <div class="container">
            <nav class="breadcrumb">
                <a href="index.php">Home</a> > <span>Social Media Caption Generator</span>
            </nav>
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">Social Media Caption Generator for GoHighLevel</h1>
                    <p class="hero-subtitle">Create engaging captions for Instagram, Facebook, LinkedIn, and Twitter to boost your social media engagement</p>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <span class="stat-number">Professional</span>
                            <span class="stat-label">Quality</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">GoHighLevel</span>
                            <span class="stat-label">Optimized</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Free Tool</span>
                        </div>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-image">
                        <div class="floating-card card-1">
                            <span class="card-icon">📱</span>
                            <span class="card-text">Social</span>
                        </div>
                        <div class="floating-card card-2">
                            <span class="card-icon">⚡</span>
                            <span class="card-text">Fast</span>
                        </div>
                        <div class="floating-card card-3">
                            <span class="card-icon">🎯</span>
                            <span class="card-text">Engaging</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Section -->
    <section class="tool-section">
        <div class="container">
            <div class="tool-card featured">
                <div class="tool-header">
                    <div class="tool-icon">📱</div>
                    <h2>Social Media Caption Generator</h2>
                    <p>Professional social media content tool designed specifically for GoHighLevel users and agencies</p>
                </div>
                
                <div class="tool-interface">
                    <div class="input-group">
                        <label for="platform">Social Media Platform</label>
                        <select id="platform">
                            <option value="">Select Platform</option>
                            <option value="instagram">Instagram</option>
                            <option value="facebook">Facebook</option>
                            <option value="linkedin">LinkedIn</option>
                            <option value="twitter">Twitter</option>
                            <option value="tiktok">TikTok</option>
                        </select>
                    </div>
                    
                    <div class="input-group">
                        <label for="contentType">Content Type</label>
                        <select id="contentType">
                            <option value="">Select Content Type</option>
                            <option value="product">Product/Service Promotion</option>
                            <option value="educational">Educational/How-to</option>
                            <option value="behind-scenes">Behind the Scenes</option>
                            <option value="testimonial">Customer Testimonial</option>
                            <option value="industry-news">Industry News</option>
                            <option value="motivational">Motivational/Inspirational</option>
                            <option value="question">Question/Engagement</option>
                            <option value="announcement">Company Announcement</option>
                        </select>
                    </div>
                    
                    <div class="input-group">
                        <label for="tone">Tone of Voice</label>
                        <select id="tone">
                            <option value="">Select Tone</option>
                            <option value="professional">Professional & Formal</option>
                            <option value="casual">Casual & Friendly</option>
                            <option value="enthusiastic">Enthusiastic & Energetic</option>
                            <option value="humorous">Humorous & Witty</option>
                            <option value="inspirational">Inspirational & Motivational</option>
                            <option value="authoritative">Authoritative & Expert</option>
                        </select>
                    </div>
                    
                    <div class="input-group">
                        <label for="keywords">Keywords (Optional)</label>
                        <input type="text" id="keywords" placeholder="Enter relevant keywords separated by commas...">
                    </div>
                    
                    <div class="button-group">
                        <button class="btn btn-primary" onclick="generateCaptions()">Generate Captions</button>
                        <button class="btn btn-secondary" onclick="generateMoreCaptions()">Generate More</button>
                        <button class="btn btn-secondary" onclick="clearResults()">Clear Results</button>
                    </div>
                    
                    <div class="result" id="captionResult" style="display: none;">
                        <h3>Generated Captions</h3>
                        <div class="captions-grid" id="captionsGrid"></div>
                        <div class="caption-actions">
                            <button class="btn btn-primary" onclick="exportCaptions()">Export Captions</button>
                            <button class="btn btn-secondary" onclick="copyAllCaptions()">Copy All</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Content Section -->
    <section class="content-section">
        <div class="container">
            <div class="content-grid">
                <article class="content-card">
                    <h2>What is a Social Media Caption Generator?</h2>
                    <p>A social media caption generator is a tool that creates engaging, platform-optimized captions for social media posts. It helps marketers and agencies create compelling content that drives engagement, increases reach, and maintains brand consistency across all social platforms.</p>
                    
                    <p>For GoHighLevel users, effective social media captions are crucial for:</p>
                    <ul>
                        <li><strong>Client Engagement:</strong> Creating content that resonates with target audiences</li>
                        <li><strong>Brand Consistency:</strong> Maintaining uniform messaging across all client accounts</li>
                        <li><strong>Time Efficiency:</strong> Generating quality content quickly for multiple clients</li>
                        <li><strong>Performance Optimization:</strong> Using proven caption strategies for better results</li>
                        <li><strong>Platform Optimization:</strong> Adapting content for each social media platform's best practices</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Why GoHighLevel Users Need This Tool</h2>
                    <p>As a GoHighLevel agency, you're managing multiple client accounts across various social media platforms. Each platform requires different content strategies, and creating engaging captions manually is time-consuming and often inconsistent.</p>
                    
                    <ul>
                        <li><strong>Multi-Client Management:</strong> Generate captions for multiple clients efficiently</li>
                        <li><strong>Platform Expertise:</strong> Access to platform-specific best practices and strategies</li>
                        <li><strong>Content Consistency:</strong> Maintain uniform brand voice across all client accounts</li>
                        <li><strong>Engagement Optimization:</strong> Use proven caption formulas for better performance</li>
                        <li><strong>Time Savings:</strong> Generate multiple caption options in seconds</li>
                        <li><strong>Professional Quality:</strong> Ensure all client content meets industry standards</li>
                        <li><strong>Scalability:</strong> Handle increased client load without sacrificing content quality</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>How to Use the Social Media Caption Generator</h2>
                    <p>Our caption generator is designed to be intuitive and comprehensive:</p>
                    
                    <ol>
                        <li><strong>Select Platform:</strong> Choose the social media platform you're creating content for</li>
                        <li><strong>Choose Content Type:</strong> Select the type of content you're promoting</li>
                        <li><strong>Set Tone:</strong> Choose the voice and personality that matches your brand</li>
                        <li><strong>Add Keywords:</strong> Include relevant terms to incorporate into your captions</li>
                        <li><strong>Generate Captions:</strong> Click to create multiple caption options</li>
                        <li><strong>Review & Customize:</strong> Select the best captions and customize as needed</li>
                        <li><strong>Copy & Use:</strong> Copy captions directly to your social media management tools</li>
                    </ol>
                </article>

                <article class="content-card">
                    <h2>Use Cases for GoHighLevel Agencies</h2>
                    <p>This tool serves multiple purposes in your daily GoHighLevel operations:</p>
                    
                    <ul>
                        <li><strong>Client Social Media Management:</strong> Create captions for all client social media accounts</li>
                        <li><strong>Content Calendar Planning:</strong> Generate captions for planned content schedules</li>
                        <li><strong>Campaign Development:</strong> Create captions for marketing campaigns and promotions</li>
                        <li><strong>Brand Building:</strong> Develop consistent brand voice across all platforms</li>
                        <li><strong>Engagement Optimization:</strong> Create captions designed to increase interaction</li>
                        <li><strong>Platform Expansion:</strong> Help clients establish presence on new social platforms</li>
                        <li><strong>Content Repurposing:</strong> Adapt existing content for different social platforms</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Platform-Specific Best Practices</h2>
                    <p>Each social media platform has unique characteristics and best practices:</p>
                    
                    <ul>
                        <li><strong>Instagram:</strong> Focus on visual storytelling, use relevant hashtags, and encourage engagement</li>
                        <li><strong>Facebook:</strong> Create community-focused content, ask questions, and share valuable information</li>
                        <li><strong>LinkedIn:</strong> Maintain professional tone, share industry insights, and network-focused content</li>
                        <li><strong>Twitter:</strong> Keep it concise, use trending hashtags, and engage in conversations</li>
                        <li><strong>TikTok:</strong> Embrace trends, use popular sounds, and create entertaining content</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Integration with GoHighLevel</h2>
                    <p>This tool integrates seamlessly with your GoHighLevel workflow:</p>
                    
                    <ul>
                        <li><strong>Content Planning:</strong> Generate captions during content calendar planning sessions</li>
                        <li><strong>Client Communication:</strong> Present caption options during client meetings</li>
                        <li><strong>Campaign Management:</strong> Create captions for integrated marketing campaigns</li>
                        <li><strong>Automation Setup:</strong> Prepare captions for automated social media posting</li>
                        <li><strong>Performance Tracking:</strong> Use optimized captions to improve social media metrics</li>
                        <li><strong>Client Training:</strong> Teach clients about effective caption strategies</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Caption Writing Strategies</h2>
                    <p>Effective captions follow proven formulas and strategies:</p>
                    
                    <ul>
                        <li><strong>Hook & Value:</strong> Start with an attention-grabbing hook, then provide value</li>
                        <li><strong>Storytelling:</strong> Use narrative elements to make content more engaging</li>
                        <li><strong>Questions:</strong> Ask questions to encourage comments and engagement</li>
                        <li><strong>Call-to-Action:</strong> Include clear instructions for what you want followers to do</li>
                        <li><strong>Emojis & Formatting:</strong> Use visual elements to break up text and add personality</li>
                        <li><strong>Hashtag Strategy:</strong> Include relevant hashtags for discoverability</li>
                        <li><strong>User-Generated Content:</strong> Encourage and showcase customer content</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Advanced Social Media Strategies</h2>
                    <p>Beyond basic caption generation, consider these advanced strategies:</p>
                    
                    <ul>
                        <li><strong>Content Pillars:</strong> Develop consistent themes and topics for your content</li>
                        <li><strong>Cross-Platform Optimization:</strong> Adapt content for each platform's unique features</li>
                        <li><strong>Trend Integration:</strong> Incorporate relevant trends and hashtags</li>
                        <li><strong>Influencer Collaboration:</strong> Partner with relevant influencers for content</li>
                        <li><strong>Community Building:</strong> Focus on building engaged communities around your brand</li>
                        <li><strong>Analytics Optimization:</strong> Use data to refine caption strategies</li>
                        <li><strong>Seasonal Content:</strong> Plan content around holidays and seasonal events</li>
                    </ul>
                </article>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="related-tools">
        <div class="container">
            <h2>Related GoHighLevel Tools</h2>
            <div class="tools-grid">
                <a href="email-subject-line-scorer.php" class="tool-link">
                    <div class="tool-icon">📧</div>
                    <h3>Email Subject Line Scorer</h3>
                    <p>Optimize your email subject lines for better open rates</p>
                </a>
                <a href="content-readability-scorer.php" class="tool-link">
                    <div class="tool-icon">📖</div>
                    <h3>Content Readability Scorer</h3>
                    <p>Analyze and improve your content readability</p>
                </a>
                <a href="keyword-density-checker.php" class="tool-link">
                    <div class="tool-icon">🔍</div>
                    <h3>Keyword Density Checker</h3>
                    <p>Analyze keyword usage in your content</p>
                </a>
            </div>
        </div>
    </section>

    <?php inc('includes/footer.php'); ?>
    <script src="common.js"></script>
    <script>`n    `n    // Load footer`n    fetch("footer.php")`n        .then(response => response.text())`n        .then(data => {`n            document.getElementById("footer-placeholder").innerHTML = data;`n        });`n});`n`n
        // Social Media Caption Generator functionality
        const captionTemplates = {
            instagram: {
                product: {
                    professional: [
                        "Discover how our innovative solution can transform your business operations. 🚀\n\nReady to experience the difference? Click the link in bio to learn more.\n\n#BusinessSolutions #Innovation #Growth",
                        "Transform your workflow with our cutting-edge platform. ✨\n\nJoin thousands of satisfied customers who've already upgraded their business.\n\n#WorkflowOptimization #BusinessTools #Success",
                        "Elevate your business to the next level with our proven solution. 📈\n\nSee real results in as little as 30 days.\n\n#BusinessGrowth #Results #Success"
                    ],
                    casual: [
                        "Hey there! 👋 Want to know what's been helping our clients crush their goals?\n\nOur amazing tool has been a game-changer! Check it out in the bio.\n\n#GameChanger #BusinessGoals #Success",
                        "So excited to share this with you! 🎉\n\nOur solution has been helping businesses like yours achieve amazing results.\n\n#Excited #BusinessSuccess #Results",
                        "Quick question: Are you ready to take your business to the next level? 🚀\n\nWe've got just the thing to help you get there!\n\n#NextLevel #BusinessGrowth #Ready"
                    ]
                },
                educational: {
                    professional: [
                        "Knowledge is power, and today we're sharing insights that can transform your approach. 📚\n\nSwipe through to discover key strategies that successful businesses use.\n\n#BusinessInsights #Learning #Strategy",
                        "Want to stay ahead of the competition? 🎯\n\nHere are proven strategies that industry leaders swear by.\n\n#CompetitiveAdvantage #Strategy #Leadership",
                        "Education is the foundation of success. 🏗️\n\nLearn from the best practices that drive results in today's market.\n\n#BestPractices #Education #Success"
                    ],
                    casual: [
                        "Did you know? 🤔\n\nThis simple strategy has helped our clients achieve amazing results!\n\n#DidYouKnow #Strategy #Results",
                        "Here's a little secret that successful businesses use! 🤫\n\nSwipe to learn more and see how you can apply it too.\n\n#BusinessSecrets #Success #Learning",
                        "Want to learn something cool today? 😎\n\nCheck out this awesome strategy that's working wonders!\n\n#Learning #Strategy #Awesome"
                    ]
                }
            },
            facebook: {
                product: {
                    professional: [
                        "Looking to optimize your business operations? Our comprehensive solution has helped hundreds of companies achieve measurable results.\n\nLearn more about how we can help your business grow and succeed in today's competitive market.\n\n#BusinessOptimization #Growth #Success",
                        "Transform your business with our innovative platform. We've designed this solution based on years of industry experience and customer feedback.\n\nJoin the growing number of businesses that trust us to deliver results.\n\n#BusinessTransformation #Innovation #Trust",
                        "Ready to take your business to the next level? Our proven solution provides the tools and insights you need to succeed.\n\nDiscover how we can help you achieve your business goals.\n\n#BusinessGrowth #Success #Goals"
                    ],
                    casual: [
                        "Hey friends! 👋 We're super excited to share something that's been helping our clients achieve amazing results!\n\nOur tool has been a total game-changer, and we think you'll love it too. Check it out and let us know what you think!\n\n#GameChanger #AmazingResults #LoveIt",
                        "So, we've got something pretty cool to share with you today! 🎉\n\nOur solution has been helping businesses like yours crush their goals, and we're pretty proud of that!\n\n#PrettyCool #CrushingGoals #Proud",
                        "Quick question for all you business owners out there: Are you ready to level up? 🚀\n\nWe've got just the thing to help you get there, and we can't wait to show you!\n\n#LevelUp #BusinessOwners #CantWait"
                    ]
                }
            },
            linkedin: {
                product: {
                    professional: [
                        "In today's competitive business landscape, organizations need innovative solutions to maintain their competitive edge.\n\nOur platform has been instrumental in helping companies optimize their operations and achieve sustainable growth.\n\nI'd love to discuss how we can support your organization's success.\n\n#BusinessInnovation #OperationalExcellence #SustainableGrowth",
                        "As business leaders, we're constantly seeking ways to improve efficiency and drive results.\n\nOur solution has delivered measurable outcomes for organizations across various industries.\n\nLet's connect to explore how we can contribute to your success.\n\n#BusinessLeadership #Efficiency #MeasurableResults",
                        "The future of business success lies in leveraging technology to optimize processes and enhance decision-making.\n\nOur platform provides the tools and insights needed to achieve these objectives.\n\nI invite you to learn more about how we can support your strategic initiatives.\n\n#FutureOfBusiness #Technology #StrategicInitiatives"
                    ]
                }
            },
            twitter: {
                product: {
                    professional: [
                        "Transform your business with our innovative solution. See real results in 30 days. #BusinessGrowth #Innovation #Results",
                        "Ready to optimize your operations? Our platform delivers measurable results. #Optimization #Results #Business",
                        "Take your business to the next level with our proven solution. #NextLevel #Business #Success"
                    ],
                    casual: [
                        "Want to know what's helping our clients crush their goals? 🚀 Our tool is a total game-changer! #GameChanger #BusinessGoals #Success",
                        "So excited to share this! Our solution has been helping businesses achieve amazing results! 🎉 #Excited #BusinessSuccess #Results",
                        "Ready to level up your business? We've got just the thing to help you get there! #LevelUp #Business #Growth"
                    ]
                }
            }
        };

        function generateCaptions() {
            const platform = document.getElementById('platform').value;
            const contentType = document.getElementById('contentType').value;
            const tone = document.getElementById('tone').value;
            const keywords = document.getElementById('keywords').value;
            
            if (!platform || !contentType || !tone) {
                alert('Please select platform, content type, and tone');
                return;
            }
            
            let captions = [];
            
            // Get base captions from templates
            if (captionTemplates[platform] && captionTemplates[platform][contentType] && captionTemplates[platform][contentType][tone]) {
                captions = [...captionTemplates[platform][contentType][tone]];
            }
            
            // Generate additional captions if needed
            if (captions.length < 5) {
                const additionalCaptions = generateAdditionalCaptions(platform, contentType, tone, keywords);
                captions = [...captions, ...additionalCaptions];
            }
            
            // Shuffle and limit results
            captions = shuffleArray(captions).slice(0, 8);
            
            displayCaptions(captions);
        }

        function generateAdditionalCaptions(platform, contentType, tone, keywords) {
            const captions = [];
            const platformSpecific = getPlatformSpecificElements(platform);
            const toneSpecific = getToneSpecificElements(tone);
            
            // Generate variations based on platform and tone
            for (let i = 0; i < 5; i++) {
                let caption = generateCaptionVariation(platform, contentType, tone, keywords, platformSpecific, toneSpecific);
                captions.push(caption);
            }
            
            return captions;
        }

        function generateCaptionVariation(platform, contentType, tone, keywords, platformSpecific, toneSpecific) {
            const hooks = [
                "Ready to transform your business?",
                "Want to know a secret?",
                "Here's what successful businesses do differently:",
                "Quick question for you:",
                "Imagine if you could...",
                "What if I told you...",
                "Here's something that might surprise you:",
                "Let's talk about..."
            ];
            
            const hooks2 = [
                "Our solution has been helping businesses achieve amazing results.",
                "We've developed a tool that's changing the game.",
                "Our platform delivers real, measurable results.",
                "We've created something that businesses love.",
                "Our solution is making a real difference."
            ];
            
            const calls = [
                "Ready to get started?",
                "Want to learn more?",
                "Interested in seeing how it works?",
                "Curious about the results?",
                "Ready to take action?"
            ];
            
            const hook = hooks[Math.floor(Math.random() * hooks.length)];
            const hook2 = hooks2[Math.floor(Math.random() * hooks2.length)];
            const call = calls[Math.floor(Math.random() * calls2.length)];
            
            let caption = `${hook}\n\n${hook2}\n\n${call} ${platformSpecific.cta} ${platformSpecific.hashtags}`;
            
            if (keywords.trim()) {
                caption = caption.replace(/\./g, ` ${keywords.trim()}.`);
            }
            
            return caption;
        }

        function getPlatformSpecificElements(platform) {
            const elements = {
                instagram: {
                    cta: "Click the link in bio to learn more.",
                    hashtags: "#BusinessGrowth #Innovation #Success #Results #Transformation"
                },
                facebook: {
                    cta: "Comment below or send us a message to learn more.",
                    hashtags: "#BusinessGrowth #Innovation #Success #Results #Transformation"
                },
                linkedin: {
                    cta: "I'd love to connect and discuss how we can help.",
                    hashtags: "#BusinessInnovation #Growth #Success #Networking #ProfessionalDevelopment"
                },
                twitter: {
                    cta: "DM us to learn more.",
                    hashtags: "#BusinessGrowth #Innovation #Success #Results #Transformation"
                },
                tiktok: {
                    cta: "Follow for more tips and tricks!",
                    hashtags: "#BusinessTips #Growth #Success #FYP #Viral"
                }
            };
            
            return elements[platform] || elements.instagram;
        }

        function getToneSpecificElements(tone) {
            const elements = {
                professional: {
                    emojis: ["🚀", "📈", "💼", "🎯", "🏆"],
                    language: ["transform", "optimize", "leverage", "implement", "execute"]
                },
                casual: {
                    emojis: ["😊", "🎉", "✨", "🔥", "💪"],
                    language: ["awesome", "amazing", "cool", "great", "fantastic"]
                },
                enthusiastic: {
                    emojis: ["🚀", "🎉", "🔥", "💥", "⭐"],
                    language: ["incredible", "phenomenal", "outstanding", "exceptional", "remarkable"]
                }
            };
            
            return elements[tone] || elements.professional;
        }

        function generateMoreCaptions() {
            generateCaptions();
        }

        function clearResults() {
            document.getElementById('captionResult').style.display = 'none';
            document.getElementById('captionsGrid').innerHTML = '';
        }

        function displayCaptions(captions) {
            const captionsGrid = document.getElementById('captionsGrid');
            let html = '';
            
            captions.forEach((caption, index) => {
                html += `
                    <div class="caption-card">
                        <div class="caption-content">${caption.replace(/\n/g, '<br>')}</div>
                        <div class="caption-actions">
                            <button class="btn btn-small" onclick="copyToClipboard('${caption.replace(/'/g, "\\'")}')">Copy</button>
                            <button class="btn btn-small btn-secondary" onclick="editCaption(${index})">Edit</button>
                        </div>
                    </div>
                `;
            });
            
            captionsGrid.innerHTML = html;
            document.getElementById('captionResult').style.display = 'block';
        }

        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(function() {
                const button = event.target;
                const originalText = button.textContent;
                button.textContent = 'Copied!';
                button.style.background = '#28a745';
                
                setTimeout(() => {
                    button.textContent = originalText;
                    button.style.background = '';
                }, 2000);
            }).catch(function(err) {
                console.error('Could not copy text: ', err);
                alert('Failed to copy caption. Please copy manually: ' + text);
            });
        }

        function editCaption(index) {
            // Simple edit functionality - could be enhanced with a modal
            const captionCards = document.querySelectorAll('.caption-content');
            const caption = captionCards[index].innerHTML.replace(/<br>/g, '\n');
            
            const newCaption = prompt('Edit your caption:', caption);
            if (newCaption && newCaption.trim()) {
                captionCards[index].innerHTML = newCaption.replace(/\n/g, '<br>');
            }
        }

        function copyAllCaptions() {
            const captions = Array.from(document.querySelectorAll('.caption-content')).map(div => div.innerHTML.replace(/<br>/g, '\n'));
            const allCaptions = captions.join('\n\n---\n\n');
            
            copyToClipboard(allCaptions);
        }

        function exportCaptions() {
            const captions = Array.from(document.querySelectorAll('.caption-content')).map(div => div.innerHTML.replace(/<br>/g, '\n'));
            const exportData = {
                timestamp: new Date().toISOString(),
                platform: document.getElementById('platform').value,
                contentType: document.getElementById('contentType').value,
                tone: document.getElementById('tone').value,
                captions: captions
            };
            
            const dataStr = JSON.stringify(exportData, null, 2);
            const dataBlob = new Blob([dataStr], {type: 'application/json'});
            
            const link = document.createElement('a');
            link.href = URL.createObjectURL(dataBlob);
            link.download = 'social-media-captions.json';
            link.click();
        }

        function shuffleArray(array) {
            const shuffled = [...array];
            for (let i = shuffled.length - 1; i > 0; i--) {
                const j = Math.floor(Math.random() * (i + 1));
                [shuffled[i], shuffled[j]] = [shuffled[j], shuffled[i]];
            }
            return shuffled;
        }

        // Add more caption templates for different content types
        captionTemplates.instagram.behind_scenes = {
            professional: [
                "Ever wonder what goes on behind the scenes? 🎬\n\nHere's a glimpse into our process and the dedication that goes into every project.\n\n#BehindTheScenes #Process #Dedication",
                "The magic happens when no one's watching. ✨\n\nTake a look at what it takes to deliver exceptional results for our clients.\n\n#Magic #Excellence #Results"
            ],
            casual: [
                "Hey there! 👋 Want to see what we're up to behind the scenes?\n\nHere's a little peek into our world!\n\n#BehindTheScenes #Peek #OurWorld",
                "So, this is what we do when you're not looking! 😄\n\nPretty cool, right?\n\n#BehindTheScenes #Cool #Fun"
            ]
        };

        captionTemplates.instagram.testimonial = {
            professional: [
                "Nothing speaks louder than results. 📊\n\nHere's what our clients are saying about their experience with us.\n\n#ClientResults #Testimonials #Success",
                "Success stories that inspire. 🌟\n\nReal feedback from real clients achieving real results.\n\n#SuccessStories #Feedback #Results"
            ],
            casual: [
                "Our clients are pretty amazing! 🎉\n\nHere's what they have to say about working with us!\n\n#AmazingClients #Feedback #Love",
                "We love hearing from our happy clients! 😊\n\nHere's what they're saying!\n\n#HappyClients #Feedback #Love"
            ]
        };
    </script>

    <style>
        .captions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
            margin: 20px 0;
        }

        .caption-card {
            background: white;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .caption-content {
            margin-bottom: 15px;
            line-height: 1.6;
            color: #333;
            white-space: pre-line;
        }

        .caption-actions {
            display: flex;
            gap: 10px;
            justify-content: flex-end;
        }

        .btn-small {
            padding: 8px 16px;
            font-size: 14px;
        }

        .caption-actions .btn {
            margin: 0;
        }

        .result .caption-actions {
            margin-top: 20px;
            justify-content: center;
        }

        .result .caption-actions .btn {
            margin: 0 10px;
        }
    </style>
</body>
</html>




