﻿<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SMS Character Counter & Cost Calculator for GoHighLevel | Free GHL Tool</title>
    <meta name="description" content="Free SMS character counter and cost calculator for GoHighLevel users. Calculate SMS costs, optimize message length, and improve your GHL SMS marketing campaigns. Perfect for agencies and businesses.">
    <meta name="keywords" content="SMS counter, SMS character counter, GoHighLevel SMS tool, SMS cost calculator, GHL SMS marketing, SMS optimization, text message counter">
    <meta name="author" content="Paddle CRM">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="SMS Character Counter & Cost Calculator for GoHighLevel">
    <meta property="og:description" content="Free SMS character counter and cost calculator for GoHighLevel users. Optimize your SMS marketing campaigns.">
    <meta property="og:url" content="https://yourdomain.com/sms-counter.php">
    <meta property="og:image" content="https://yourdomain.com/images/sms-counter-og.jpg">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="SMS Character Counter & Cost Calculator for GoHighLevel">
    <meta property="twitter:description" content="Free SMS character counter and cost calculator for GoHighLevel users. Optimize your SMS marketing campaigns.">
    <meta property="twitter:image" content="https://yourdomain.com/images/sms-counter-twitter.jpg">
    
    <!-- Schema.org structured data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "SMS Character Counter & Cost Calculator for GoHighLevel",
        "description": "Free tool to count SMS characters and calculate costs for GoHighLevel SMS marketing campaigns",
        "url": "https://yourdomain.com/sms-counter.php",
        "applicationCategory": "BusinessApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Paddle CRM",
            "description": "WhiteLabel GoHighLevel Agency"
        }
    }
    </script>
    
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php inc('includes/header.php'); ?>

    <!-- Hero Section -->
    <section class="hero tool-hero">
        <div class="container">
            <nav class="breadcrumb">
                <a href="index.php">Home</a> > <span>SMS Counter</span>
            </nav>
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">
                        SMS Character Counter & 
                        <span class="highlight">Cost Calculator</span>
                    </h1>
                    <p class="hero-subtitle">
                        Optimize your GoHighLevel SMS marketing campaigns with precise character counting, 
                        cost analysis, and professional insights. Perfect for agencies and businesses.
                    </p>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <span class="stat-number">160</span>
                            <span class="stat-label">Char Limit</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">Real-time</span>
                            <span class="stat-label">Analysis</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Free Tool</span>
                        </div>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-image">
                        <div class="floating-card card-1">
                            <span class="card-icon">📱</span>
                            <span class="card-text">SMS Counter</span>
                        </div>
                        <div class="floating-card card-2">
                            <span class="card-icon">💰</span>
                            <span class="card-text">Cost Calc</span>
                        </div>
                        <div class="floating-card card-3">
                            <span class="card-icon">⚡</span>
                            <span class="card-text">Real-time</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Section -->
    <section class="tool-section">
        <div class="container">
            <div class="tool-card featured">
                <div class="tool-header">
                    <div class="tool-icon">📱</div>
                    <h2>SMS Character Counter & Cost Calculator</h2>
                    <p>Professional SMS optimization tool designed specifically for GoHighLevel users and agencies</p>
                </div>
                
                <div class="tool-interface">
                    <div class="input-group">
                        <label for="smsText">SMS Message</label>
                        <textarea id="smsText" rows="6" placeholder="Type or paste your SMS message here..."></textarea>
                    </div>
                    
                    <div class="sms-stats">
                        <div class="stat-item">
                            <span class="stat-label">Characters:</span>
                            <span id="charCount" class="stat-value">0</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-label">Messages:</span>
                            <span id="messageCount" class="stat-value">1</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-label">Cost (est.):</span>
                            <span id="estimatedCost" class="stat-value">$0.00</span>
                        </div>
                    </div>
                    
                    <div class="cost-calculator">
                        <h4>Cost Calculator</h4>
                        <div class="input-row">
                            <div class="input-group">
                                <label for="costPerMessage">Cost per SMS</label>
                                <input type="number" id="costPerMessage" value="0.05" step="0.01" min="0">
                            </div>
                            <div class="input-group">
                                <label for="totalMessages">Total Messages</label>
                                <input type="number" id="totalMessages" value="1000" min="1">
                            </div>
                        </div>
                        <div class="total-cost">
                            <span class="cost-label">Total Cost:</span>
                            <span id="totalCost" class="cost-value">$50.00</span>
                        </div>
                    </div>
                    
                    <div class="tool-actions">
                        <button class="btn btn-primary" onclick="copyToClipboard(document.getElementById('smsText').value)">
                            Copy Message
                        </button>
                        <button class="btn btn-secondary" onclick="clearSMS()">
                            Clear All
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Content Section -->
    <section class="content-section">
        <div class="container">
            <div class="content-grid">
                <div class="content-card">
                    <h3>Why Use Our SMS Counter for GoHighLevel?</h3>
                    <p>Our SMS character counter is specifically designed for GoHighLevel users and agencies who need precise control over their SMS marketing campaigns. With real-time character counting and cost analysis, you can optimize your messages for maximum impact and cost efficiency.</p>
                    
                    <h4>Key Features:</h4>
                    <ul>
                        <li><strong>Real-time Character Counting:</strong> See exactly how many characters your message contains as you type</li>
                        <li><strong>Message Segmentation:</strong> Automatically calculate how many SMS messages your content will require</li>
                        <li><strong>Cost Analysis:</strong> Estimate costs based on your SMS provider's pricing</li>
                        <li><strong>GoHighLevel Integration:</strong> Designed specifically for GHL workflows and best practices</li>
                        <li><strong>Mobile Optimized:</strong> Works perfectly on all devices for on-the-go optimization</li>
                    </ul>
                </div>
                
                <div class="content-card">
                    <h3>How to Optimize SMS for GoHighLevel</h3>
                    <p>Effective SMS marketing in GoHighLevel requires careful attention to character limits and message structure. Here are some expert tips:</p>
                    
                    <h4>SMS Best Practices:</h4>
                    <ul>
                        <li><strong>Keep it Under 160 Characters:</strong> Single SMS messages are more cost-effective</li>
                        <li><strong>Clear Call-to-Action:</strong> Make your message actionable and easy to respond to</li>
                        <li><strong>Personalization:</strong> Use GoHighLevel's merge fields for personalized messaging</li>
                        <li><strong>Timing:</strong> Send messages during optimal hours for your audience</li>
                        <li><strong>Compliance:</strong> Always include opt-out instructions and respect privacy laws</li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

    <!-- Related Tools Section -->
    <section class="related-tools">
        <div class="container">
            <h3>Related GoHighLevel Tools</h3>
            <div class="tools-grid">
                <a href="roi-calculator.php" class="tool-link">
                    <div class="tool-icon">💰</div>
                    <h4>ROI Calculator</h4>
                    <p>Calculate campaign returns and optimize your marketing spend</p>
                </a>
                <a href="lead-scoring.php" class="tool-link">
                    <div class="tool-icon">⭐</div>
                    <h4>Lead Scoring</h4>
                    <p>Score and prioritize your leads for better conversion rates</p>
                </a>
                <a href="email-subject-line-scorer.php" class="tool-link">
                    <div class="tool-icon">📧</div>
                    <h4>Email Subject Scorer</h4>
                    <p>Optimize your email subject lines for higher open rates</p>
                </a>
                <a href="funnel-calculator.php" class="tool-link">
                    <div class="tool-icon">🔄</div>
                    <h4>Funnel Calculator</h4>
                    <p>Analyze your sales funnel performance and identify bottlenecks</p>
                </a>
            </div>
        </div>
    </section>

    <?php inc('includes/footer.php'); ?>

    <script src="common.js"></script>
    <script>
        // SMS Counter functionality
        const smsText = document.getElementById('smsText');
        const charCount = document.getElementById('charCount');
        const messageCount = document.getElementById('messageCount');
        const estimatedCost = document.getElementById('estimatedCost');
        const costPerMessage = document.getElementById('costPerMessage');
        const totalMessages = document.getElementById('totalMessages');
        const totalCost = document.getElementById('totalCost');

        function updateSMSCount() {
            const text = smsText.value;
            const chars = text.length;
            const messages = Math.ceil(chars / 160);
            const cost = (messages * parseFloat(costPerMessage.value)).toFixed(2);
            
            charCount.textContent = chars;
            messageCount.textContent = messages;
            estimatedCost.textContent = `$${cost}`;
            
            updateTotalCost();
        }

        function updateTotalCost() {
            const messages = parseInt(totalMessages.value);
            const costPer = parseFloat(costPerMessage.value);
            const total = (messages * costPer).toFixed(2);
            totalCost.textContent = `$${total}`;
        }

        function clearSMS() {
            smsText.value = '';
            updateSMSCount();
        }

        // Event listeners
        smsText.addEventListener('input', updateSMSCount);
        costPerMessage.addEventListener('input', updateSMSCount);
        totalMessages.addEventListener('input', updateTotalCost);

        // Initialize
        updateSMSCount();
        updateTotalCost();
    </script>
</body>
</html>

