﻿<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Meta Tag Generator for GoHighLevel | Free SEO Meta Tag Tool</title>
    <meta name="description" content="Free meta tag generator for GoHighLevel users. Create optimized meta tags for SEO, social media, and web pages. Perfect for agencies optimizing client websites.">
    <meta name="keywords" content="meta tag generator, SEO meta tags, Open Graph tags, Twitter cards, meta description generator, GoHighLevel agency">
    <meta name="author" content="Paddle CRM">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="Meta Tag Generator for GoHighLevel">
    <meta property="og:description" content="Free meta tag generator for GoHighLevel users. Create optimized meta tags for SEO, social media, and web pages.">
    <meta property="og:url" content="https://yourdomain.com/meta-tag-generator.php">
    <meta property="og:image" content="https://yourdomain.com/images/meta-tag-generator-og.jpg">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="Meta Tag Generator for GoHighLevel">
    <meta property="twitter:description" content="Free meta tag generator for GoHighLevel users. Create optimized meta tags for SEO, social media, and web pages.">
    <meta property="twitter:image" content="https://yourdomain.com/images/meta-tag-generator-og.jpg">
    
    <!-- Schema.org structured data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Meta Tag Generator for GoHighLevel",
        "description": "Free tool to generate optimized meta tags for SEO and social media",
        "url": "https://yourdomain.com/meta-tag-generator.php",
        "applicationCategory": "BusinessApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Paddle CRM",
            "description": "WhiteLabel GoHighLevel Agency"
        }
    }
    </script>
    
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php inc('includes/header.php'); ?>

    <!-- Hero Section -->
    <section class="hero tool-hero">
        <div class="container">
            <nav class="breadcrumb">
                <a href="index.php">Home</a> > <span>Meta Tag Generator</span>
            </nav>
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">Meta Tag Generator for GoHighLevel</h1>
                    <p class="hero-subtitle">Create optimized meta tags for SEO, social media, and web pages to improve search rankings and social sharing</p>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <span class="stat-number">Professional</span>
                            <span class="stat-label">Quality</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">GoHighLevel</span>
                            <span class="stat-label">Optimized</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Free Tool</span>
                        </div>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-image">
                        <div class="floating-card card-1">
                            <span class="card-icon">🏷️</span>
                            <span class="card-text">Meta Tags</span>
                        </div>
                        <div class="floating-card card-2">
                            <span class="card-icon">⚡</span>
                            <span class="card-text">Fast</span>
                        </div>
                        <div class="floating-card card-3">
                            <span class="card-icon">🎯</span>
                            <span class="card-text">SEO</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Section -->
    <section class="tool-section">
        <div class="container">
            <div class="tool-card featured">
                <div class="tool-header">
                    <div class="tool-icon">🏷️</div>
                    <h2>Meta Tag Generator</h2>
                    <p>Professional meta tag generation tool designed specifically for GoHighLevel users and agencies</p>
                </div>
                
                <div class="tool-interface">
                    <div class="input-group">
                        <label for="pageTitle">Page Title</label>
                        <input type="text" id="pageTitle" placeholder="Enter your page title (50-60 characters recommended)">
                        <div class="char-counter">
                            <span id="titleCounter">0</span>/60 characters
                        </div>
                    </div>
                    
                    <div class="input-group">
                        <label for="pageDescription">Meta Description</label>
                        <textarea id="pageDescription" rows="3" placeholder="Enter your meta description (150-160 characters recommended)"></textarea>
                        <div class="char-counter">
                            <span id="descCounter">0</span>/160 characters
                        </div>
                    </div>
                    
                    <div class="input-group">
                        <label for="pageKeywords">Keywords (comma-separated)</label>
                        <input type="text" id="pageKeywords" placeholder="keyword1, keyword2, keyword3">
                    </div>
                    
                    <div class="input-group">
                        <label for="pageUrl">Page URL</label>
                        <input type="url" id="pageUrl" placeholder="https://yourdomain.com/page">
                    </div>
                    
                    <div class="input-group">
                        <label for="pageImage">Social Media Image URL</label>
                        <input type="url" id="pageImage" placeholder="https://yourdomain.com/images/social-image.jpg">
                    </div>
                    
                    <div class="input-group">
                        <label for="pageType">Page Type</label>
                        <select id="pageType">
                            <option value="website">Website</option>
                            <option value="article">Article/Blog Post</option>
                            <option value="product">Product Page</option>
                            <option value="service">Service Page</option>
                            <option value="landing">Landing Page</option>
                        </select>
                    </div>
                    
                    <div class="button-group">
                        <button class="btn btn-primary" onclick="generateMetaTags()">Generate Meta Tags</button>
                        <button class="btn btn-secondary" onclick="previewTags()">Preview Tags</button>
                        <button class="btn btn-secondary" onclick="clearForm()">Clear Form</button>
                    </div>
                    
                    <div class="result" id="metaTagResult" style="display: none;">
                        <h3>Generated Meta Tags</h3>
                        
                        <div class="meta-tabs">
                            <button class="tab-btn active" onclick="showTab('basic')">Basic SEO</button>
                            <button class="tab-btn" onclick="showTab('social')">Social Media</button>
                            <button class="tab-btn" onclick="showTab('advanced')">Advanced</button>
                            <button class="tab-btn" onclick="showTab('preview')">Preview</button>
                        </div>
                        
                        <div class="tab-content">
                            <div id="basic-tab" class="tab-pane active">
                                <div class="code-block">
                                    <h4>HTML Meta Tags</h4>
                                    <pre><code id="basicMetaTags"></code></pre>
                                    <button class="btn btn-secondary" onclick="copyToClipboard('basicMetaTags')">Copy Code</button>
                                </div>
                            </div>
                            
                            <div id="social-tab" class="tab-pane">
                                <div class="code-block">
                                    <h4>Open Graph & Twitter Cards</h4>
                                    <pre><code id="socialMetaTags"></code></pre>
                                    <button class="btn btn-secondary" onclick="copyToClipboard('socialMetaTags')">Copy Code</button>
                                </div>
                            </div>
                            
                            <div id="advanced-tab" class="tab-pane">
                                <div class="code-block">
                                    <h4>Advanced Meta Tags</h4>
                                    <pre><code id="advancedMetaTags"></code></pre>
                                    <button class="btn btn-secondary" onclick="copyToClipboard('advancedMetaTags')">Copy Code</button>
                                </div>
                            </div>
                            
                            <div id="preview-tab" class="tab-pane">
                                <div class="preview-section">
                                    <h4>Search Result Preview</h4>
                                    <div class="search-preview">
                                        <div class="preview-title" id="previewTitle"></div>
                                        <div class="preview-url" id="previewUrl"></div>
                                        <div class="preview-description" id="previewDescription"></div>
                                    </div>
                                    
                                    <h4>Social Media Preview</h4>
                                    <div class="social-preview">
                                        <div class="social-card">
                                            <div class="social-image" id="socialImage"></div>
                                            <div class="social-content">
                                                <div class="social-title" id="socialTitle"></div>
                                                <div class="social-description" id="socialDescription"></div>
                                                <div class="social-url" id="socialUrl"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="meta-actions">
                            <button class="btn btn-primary" onclick="exportTags()">Export All Tags</button>
                            <button class="btn btn-secondary" onclick="validateTags()">Validate Tags</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Content Section -->
    <section class="content-section">
        <div class="container">
            <div class="content-grid">
                <article class="content-card">
                    <h2>What are Meta Tags?</h2>
                    <p>Meta tags are HTML elements that provide metadata about a web page. They are placed in the head section of HTML documents and serve as instructions for search engines, social media platforms, and web browsers. Meta tags are crucial for SEO, social media sharing, and overall web page optimization.</p>
                    
                    <p>For GoHighLevel users, understanding meta tags is essential because:</p>
                    <ul>
                        <li><strong>SEO Performance:</strong> Meta tags directly impact search engine rankings and click-through rates</li>
                        <li><strong>Social Media:</strong> Proper meta tags ensure attractive social media previews</li>
                        <li><strong>User Experience:</strong> Well-crafted meta descriptions improve user engagement</li>
                        <li><strong>Client Results:</strong> Better SEO means better results for your agency clients</li>
                        <li><strong>Professional Credibility:</strong> Demonstrates technical expertise to clients</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Why GoHighLevel Users Need This Tool</h2>
                    <p>As a GoHighLevel agency, you're constantly creating and optimizing web pages for clients. Meta tags are a fundamental aspect of web optimization that can significantly impact client results. This tool helps you create professional, optimized meta tags quickly and efficiently.</p>
                    
                    <ul>
                        <li><strong>Time Efficiency:</strong> Generate optimized meta tags in seconds instead of hours</li>
                        <li><strong>Client Quality:</strong> Ensure all client pages have proper SEO optimization</li>
                        <li><strong>Professional Standards:</strong> Maintain high-quality output for all client work</li>
                        <li><strong>SEO Expertise:</strong> Demonstrate technical knowledge to clients</li>
                        <li><strong>Consistent Results:</strong> Standardize meta tag creation across all projects</li>
                        <li><strong>Competitive Advantage:</strong> Stand out as an agency that prioritizes technical SEO</li>
                        <li><strong>Client Education:</strong> Teach clients about the importance of meta tags</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>How to Use the Meta Tag Generator</h2>
                    <p>Our meta tag generator is designed to provide comprehensive optimization and professional results:</p>
                    
                    <ol>
                        <li><strong>Enter Page Information:</strong> Input your page title, description, and keywords</li>
                        <li><strong>Set Page Details:</strong> Specify the page URL and social media image</li>
                        <li><strong>Choose Page Type:</strong> Select the appropriate page category for optimal tags</li>
                        <li><strong>Generate Tags:</strong> Click to create optimized meta tags</li>
                        <li><strong>Review Results:</strong> Examine the generated tags across different categories</li>
                        <li><strong>Preview Appearance:</strong> See how your page will look in search results and social media</li>
                        <li><strong>Export Code:</strong> Copy the generated HTML code for implementation</li>
                    </ol>
                </article>

                <article class="content-card">
                    <h2>Use Cases for GoHighLevel Agencies</h2>
                    <p>This tool serves multiple purposes in your daily GoHighLevel operations:</p>
                    
                    <ul>
                        <li><strong>Client Website Optimization:</strong> Create meta tags for all client pages</li>
                        <li><strong>Landing Page Creation:</strong> Optimize new landing pages for better performance</li>
                        <li><strong>Blog Post Optimization:</strong> Ensure all blog content is properly tagged</li>
                        <li><strong>Product Page SEO:</strong> Optimize e-commerce pages for search engines</li>
                        <li><strong>Service Page Enhancement:</strong> Improve service page visibility and engagement</li>
                        <li><strong>Client Training:</strong> Educate clients about meta tag importance</li>
                        <li><strong>Competitive Analysis:</strong> Analyze competitor meta tags for insights</li>
                        <li><strong>Performance Monitoring:</strong> Track improvements after meta tag optimization</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Key Meta Tag Types</h2>
                    <p>Understanding these meta tag categories helps you create comprehensive optimization:</p>
                    
                    <ul>
                        <li><strong>Basic SEO Tags:</strong> Title, description, keywords, and robots directives</li>
                        <li><strong>Open Graph Tags:</strong> Facebook and other social media platform optimization</li>
                        <li><strong>Twitter Cards:</strong> Twitter-specific social media optimization</li>
                        <li><strong>Technical Tags:</strong> Character encoding, viewport settings, and compatibility</li>
                        <li><strong>Schema Markup:</strong> Structured data for enhanced search results</li>
                        <li><strong>Canonical Tags:</strong> Prevent duplicate content issues</li>
                        <li><strong>Language Tags:</strong> Specify page language for international SEO</li>
                        <li><strong>Mobile Tags:</strong> Optimize for mobile devices and responsive design</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Integration with GoHighLevel</h2>
                    <p>This tool integrates seamlessly with your GoHighLevel workflow:</p>
                    
                    <ul>
                        <li><strong>Page Creation:</strong> Generate meta tags during page development</li>
                        <li><strong>Client Deliverables:</strong> Include meta tag optimization in client packages</li>
                        <li><strong>Template Development:</strong> Create optimized templates for client use</li>
                        <li><strong>Content Strategy:</strong> Ensure all content follows SEO best practices</li>
                        <li><strong>Performance Monitoring:</strong> Track SEO improvements after implementation</li>
                        <li><strong>Client Education:</strong> Teach clients about technical SEO</li>
                        <li><strong>Service Documentation:</strong> Document SEO improvements for client records</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Meta Tag Best Practices</h2>
                    <p>Following these best practices ensures optimal results:</p>
                    
                    <ul>
                        <li><strong>Title Length:</strong> Keep titles between 50-60 characters for optimal display</li>
                        <li><strong>Description Length:</strong> Maintain descriptions between 150-160 characters</li>
                        <li><strong>Keyword Placement:</strong> Include primary keywords naturally in titles and descriptions</li>
                        <li><strong>Unique Content:</strong> Avoid duplicate meta tags across different pages</li>
                        <li><strong>Social Optimization:</strong> Use compelling descriptions for social media sharing</li>
                        <li><strong>Mobile Consideration:</strong> Ensure tags work well on mobile devices</li>
                        <li><strong>Regular Updates:</strong> Review and update meta tags periodically</li>
                        <li><strong>Performance Testing:</strong> Monitor SEO performance after meta tag changes</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Advanced Meta Tag Strategies</h2>
                    <p>Beyond basic implementation, consider these advanced strategies:</p>
                    
                    <ul>
                        <li><strong>Dynamic Tag Generation:</strong> Create tags based on page content automatically</li>
                        <li><strong>A/B Testing:</strong> Test different meta tags for better performance</li>
                        <li><strong>Seasonal Optimization:</strong> Update tags for seasonal campaigns and events</li>
                        <li><strong>Local SEO Integration:</strong> Include location-specific meta tags for local businesses</li>
                        <li><strong>E-commerce Optimization:</strong> Use product-specific meta tags for better conversions</li>
                        <li><strong>Multilingual Support:</strong> Implement language-specific meta tags for international audiences</li>
                        <li><strong>Performance Monitoring:</strong> Track click-through rates and rankings</li>
                        <li><strong>Competitive Analysis:</strong> Monitor competitor meta tag strategies</li>
                    </ul>
                </article>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="related-tools">
        <div class="container">
            <h2>Related GoHighLevel Tools</h2>
            <div class="tools-grid">
                <a href="keyword-density-checker.php" class="tool-link">
                    <div class="tool-icon">🔍</div>
                    <h3>Keyword Density Checker</h3>
                    <p>Analyze keyword usage and optimize your content for SEO</p>
                </a>
                <a href="content-readability-scorer.php" class="tool-link">
                    <div class="tool-icon">📖</div>
                    <h3>Content Readability Scorer</h3>
                    <p>Improve your content readability and user engagement</p>
                </a>
                <a href="seo-analyzer.php" class="tool-link">
                    <div class="tool-icon">📊</div>
                    <h3>SEO Analyzer</h3>
                    <p>Comprehensive SEO analysis for your web pages</p>
                </a>
            </div>
        </div>
    </section>

    <?php inc('includes/footer.php'); ?>
    <script src="common.js"></script>
    <script>`n    `n    // Load footer`n    fetch("footer.php")`n        .then(response => response.text())`n        .then(data => {`n            document.getElementById("footer-placeholder").innerHTML = data;`n        });`n});`n`n
        // Meta Tag Generator functionality
        let currentTab = 'basic';
        
        // Character counters
        document.getElementById('pageTitle').addEventListener('input', function() {
            const count = this.value.length;
            document.getElementById('titleCounter').textContent = count;
            document.getElementById('titleCounter').style.color = count > 60 ? '#dc3545' : '#28a745';
        });
        
        document.getElementById('pageDescription').addEventListener('input', function() {
            const count = this.value.length;
            document.getElementById('descCounter').textContent = count;
            document.getElementById('descCounter').style.color = count > 160 ? '#dc3545' : '#28a745';
        });
        
        function generateMetaTags() {
            const title = document.getElementById('pageTitle').value.trim();
            const description = document.getElementById('pageDescription').value.trim();
            const keywords = document.getElementById('pageKeywords').value.trim();
            const url = document.getElementById('pageUrl').value.trim();
            const image = document.getElementById('pageImage').value.trim();
            const pageType = document.getElementById('pageType').value;
            
            if (!title || !description) {
                alert('Please enter at least a title and description');
                return;
            }
            
            const metaTags = createMetaTags(title, description, keywords, url, image, pageType);
            displayMetaTags(metaTags);
            updatePreview(title, description, url, image);
        }
        
        function createMetaTags(title, description, keywords, url, image, pageType) {
            const basicTags = `<!-- Basic SEO Meta Tags -->
<title>${title}</title>
<meta name="description" content="${description}">
<meta name="keywords" content="${keywords}">
<meta name="author" content="Your Company Name">
<meta name="robots" content="index, follow">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta charset="UTF-8">`;
            
            const socialTags = `<!-- Open Graph Meta Tags -->
<meta property="og:type" content="${pageType}">
<meta property="og:title" content="${title}">
<meta property="og:description" content="${description}">
<meta property="og:url" content="${url}">
<meta property="og:image" content="${image}">
<meta property="og:site_name" content="Your Site Name">

<!-- Twitter Card Meta Tags -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="${title}">
<meta name="twitter:description" content="${description}">
<meta name="twitter:image" content="${image}">`;
            
            const advancedTags = `<!-- Advanced Meta Tags -->
<link rel="canonical" href="${url}">
<meta name="language" content="English">
<meta name="revisit-after" content="7 days">
<meta name="distribution" content="global">
<meta name="rating" content="general">
<meta name="theme-color" content="#ffffff">`;
            
            return { basicTags, socialTags, advancedTags };
        }
        
        function displayMetaTags(metaTags) {
            document.getElementById('basicMetaTags').textContent = metaTags.basicTags;
            document.getElementById('socialMetaTags').textContent = metaTags.socialTags;
            document.getElementById('advancedMetaTags').textContent = metaTags.advancedTags;
            document.getElementById('metaTagResult').style.display = 'block';
        }
        
        function updatePreview(title, description, url, image) {
            document.getElementById('previewTitle').textContent = title;
            document.getElementById('previewUrl').textContent = url;
            document.getElementById('previewDescription').textContent = description;
            
            document.getElementById('socialTitle').textContent = title;
            document.getElementById('socialDescription').textContent = description;
            document.getElementById('socialUrl').textContent = url;
            
            if (image) {
                document.getElementById('socialImage').style.backgroundImage = `url(${image})`;
                document.getElementById('socialImage').style.display = 'block';
            } else {
                document.getElementById('socialImage').style.display = 'none';
            }
        }
        
        function showTab(tabName) {
            // Hide all tab panes
            const tabPanes = document.querySelectorAll('.tab-pane');
            tabPanes.forEach(pane => pane.classList.remove('active'));
            
            // Remove active class from all tab buttons
            const tabButtons = document.querySelectorAll('.tab-btn');
            tabButtons.forEach(btn => btn.classList.remove('active'));
            
            // Show selected tab pane
            document.getElementById(tabName + '-tab').classList.add('active');
            
            // Add active class to selected tab button
            event.target.classList.add('active');
            
            currentTab = tabName;
        }
        
        function previewTags() {
            generateMetaTags();
            showTab('preview');
        }
        
        function clearForm() {
            document.getElementById('pageTitle').value = '';
            document.getElementById('pageDescription').value = '';
            document.getElementById('pageKeywords').value = '';
            document.getElementById('pageUrl').value = '';
            document.getElementById('pageImage').value = '';
            document.getElementById('pageType').value = 'website';
            document.getElementById('metaTagResult').style.display = 'none';
            document.getElementById('titleCounter').textContent = '0';
            document.getElementById('descCounter').textContent = '0';
            document.getElementById('titleCounter').style.color = '#28a745';
            document.getElementById('descCounter').style.color = '#28a745';
        }
        
        function copyToClipboard(elementId) {
            const text = document.getElementById(elementId).textContent;
            navigator.clipboard.writeText(text).then(() => {
                alert('Code copied to clipboard!');
            }).catch(err => {
                console.error('Failed to copy: ', err);
                // Fallback for older browsers
                const textArea = document.createElement('textarea');
                textArea.value = text;
                document.body.appendChild(textArea);
                textArea.select();
                document.execCommand('copy');
                document.body.removeChild(textArea);
                alert('Code copied to clipboard!');
            });
        }
        
        function exportTags() {
            const title = document.getElementById('pageTitle').value.trim();
            const description = document.getElementById('pageDescription').value.trim();
            const keywords = document.getElementById('pageKeywords').value.trim();
            const url = document.getElementById('pageUrl').value.trim();
            const image = document.getElementById('pageImage').value.trim();
            const pageType = document.getElementById('pageType').value;
            
            const metaTags = createMetaTags(title, description, keywords, url, image, pageType);
            const allTags = `<!-- Complete Meta Tag Package for ${title} -->
${metaTags.basicTags}

${metaTags.socialTags}

${metaTags.advancedTags}`;
            
            const dataBlob = new Blob([allTags], {type: 'text/plain'});
            const link = document.createElement('a');
            link.href = URL.createObjectURL(dataBlob);
            link.download = 'meta-tags.php';
            link.click();
        }
        
        function validateTags() {
            const title = document.getElementById('pageTitle').value.trim();
            const description = document.getElementById('pageDescription').value.trim();
            const keywords = document.getElementById('pageKeywords').value.trim();
            
            let validationResults = '<h4>Meta Tag Validation Results</h4><ul>';
            let hasIssues = false;
            
            if (title.length < 30) {
                validationResults += '<li>⚠️ Title is too short (recommended: 30-60 characters)</li>';
                hasIssues = true;
            } else if (title.length > 60) {
                validationResults += '<li>⚠️ Title is too long (recommended: 30-60 characters)</li>';
                hasIssues = true;
            } else {
                validationResults += '<li>✅ Title length is optimal</li>';
            }
            
            if (description.length < 120) {
                validationResults += '<li>⚠️ Description is too short (recommended: 120-160 characters)</li>';
                hasIssues = true;
            } else if (description.length > 160) {
                validationResults += '<li>⚠️ Description is too long (recommended: 120-160 characters)</li>';
                hasIssues = true;
            } else {
                validationResults += '<li>✅ Description length is optimal</li>';
            }
            
            if (!keywords) {
                validationResults += '<li>⚠️ No keywords specified</li>';
                hasIssues = true;
            } else {
                validationResults += '<li>✅ Keywords are specified</li>';
            }
            
            if (!hasIssues) {
                validationResults += '<li>🎉 All meta tags pass validation!</li>';
            }
            
            validationResults += '</ul>';
            
            alert('Validation complete! Check the console for detailed results.');
            console.log(validationResults);
        }
    </script>

    <style>
        .char-counter {
            font-size: 12px;
            color: #666;
            text-align: right;
            margin-top: 5px;
        }
        
        .meta-tabs {
            display: flex;
            border-bottom: 2px solid #e9ecef;
            margin-bottom: 20px;
        }
        
        .tab-btn {
            background: none;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            border-bottom: 2px solid transparent;
            transition: all 0.3s ease;
        }
        
        .tab-btn.active {
            border-bottom-color: #007bff;
            color: #007bff;
            font-weight: 600;
        }
        
        .tab-btn:hover {
            background-color: #f8f9fa;
        }
        
        .tab-pane {
            display: none;
        }
        
        .tab-pane.active {
            display: block;
        }
        
        .code-block {
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .code-block h4 {
            margin: 0 0 15px 0;
            color: #333;
        }
        
        .code-block pre {
            background: #2d3748;
            color: #e2e8f0;
            padding: 15px;
            border-radius: 6px;
            overflow-x: auto;
            margin: 0 0 15px 0;
        }
        
        .code-block code {
            font-family: 'Courier New', monospace;
            font-size: 14px;
            line-height: 1.4;
        }
        
        .preview-section {
            margin: 20px 0;
        }
        
        .search-preview {
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .preview-title {
            color: #1a0dab;
            font-size: 18px;
            font-weight: 500;
            margin-bottom: 5px;
        }
        
        .preview-url {
            color: #006621;
            font-size: 14px;
            margin-bottom: 10px;
        }
        
        .preview-description {
            color: #545454;
            font-size: 14px;
            line-height: 1.4;
        }
        
        .social-preview {
            background: #f8f9fa;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            padding: 20px;
        }
        
        .social-card {
            background: white;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            overflow: hidden;
            max-width: 400px;
        }
        
        .social-image {
            height: 200px;
            background-size: cover;
            background-position: center;
            background-color: #e9ecef;
            display: none;
        }
        
        .social-content {
            padding: 15px;
        }
        
        .social-title {
            font-weight: 600;
            margin-bottom: 8px;
            color: #333;
        }
        
        .social-description {
            color: #666;
            margin-bottom: 8px;
            line-height: 1.4;
        }
        
        .social-url {
            color: #006621;
            font-size: 12px;
        }
        
        .meta-actions {
            margin-top: 20px;
            text-align: center;
        }
        
        .meta-actions .btn {
            margin: 0 10px;
        }
    </style>
</body>
</html>




