<?php
/**
 * Standard Tool Template for GHL Toolset
 * Copy and customize this template for each tool
 */

// Load configuration and includes
require_once('config.php');
require_once('includes/seo.php');
require_once('includes/affiliates.php');
require_once('includes/ad-slot.php');
require_once('includes/cta.php');

// Tool-specific configuration (CUSTOMIZE THESE)
$toolName = 'Tool Name'; // e.g., 'SMS Counter'
$toolSlug = 'tool-slug'; // e.g., 'sms-counter'
$toolDescription = 'Tool description for meta tags';
$toolFeatures = [
    'Feature 1',
    'Feature 2',
    'Feature 3'
];

// SEO Configuration
$pageTitle = optimize_title($toolName . ' for GoHighLevel | Free GHL Tool');
$pageDescription = optimize_description($toolDescription);
$canonicalUrl = get_canonical_url($toolSlug);
$keywords = 'tool keywords, GoHighLevel, GHL, free tool';

// Schema markup
$toolSchema = get_tool_schema(
    $toolName . ' for GoHighLevel',
    $toolDescription,
    $canonicalUrl,
    $toolFeatures
);

// FAQ data (customize per tool)
$faqs = [
    [
        'question' => 'How does this tool work?',
        'answer' => 'This tool helps you...'
    ],
    [
        'question' => 'Is this tool free?',
        'answer' => 'Yes, this tool is completely free to use.'
    ],
    [
        'question' => 'Can I use this with GoHighLevel?',
        'answer' => 'Yes, this tool is specifically designed for GoHighLevel users.'
    ]
];

$faqSchema = get_faq_schema($faqs);

// Breadcrumbs
$breadcrumbs = [
    ['name' => 'Home', 'url' => get_canonical_url()],
    ['name' => 'Tools', 'url' => get_canonical_url() . '#tools'],
    ['name' => $toolName, 'url' => $canonicalUrl]
];
$breadcrumbSchema = get_breadcrumb_schema($breadcrumbs);

// Get ad slots for this tool
$adSlots = get_tool_ad_slots($toolSlug);

// Get relevant affiliate partners
$affiliatePartners = get_tool_affiliates($toolSlug);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <?php 
    render_meta($pageTitle, $pageDescription, $canonicalUrl, $keywords);
    render_schema($toolSchema);
    render_schema($faqSchema);
    render_schema($breadcrumbSchema);
    render_preconnects();
    ?>
    
    <link rel="stylesheet" href="public/css/tokens.css">
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Tool-specific JavaScript configuration -->
    <script>
        window.GA4_ID = '<?php echo GA4_ID; ?>';
        window.ADSENSE_PUB = '<?php echo ADSENSE_PUB; ?>';
        window.pageLoadTime = Date.now();
    </script>
</head>
<body>
    <a href="#main-content" class="skip-to-content">Skip to content</a>
    
    <?php include 'includes/header.php'; ?>
    
    <main id="main-content">
        <!-- Tool Hero Section -->
        <section class="tool-hero">
            <div class="container">
                <div class="breadcrumb">
                    <a href="<?php echo get_canonical_url(); ?>">Home</a>
                    <span>/</span>
                    <a href="<?php echo get_canonical_url(); ?>#tools">Tools</a>
                    <span>/</span>
                    <span><?php echo htmlspecialchars($toolName); ?></span>
                </div>
                
                <h1 class="tool-title"><?php echo htmlspecialchars($toolName); ?></h1>
                <p class="tool-subtitle"><?php echo htmlspecialchars($toolDescription); ?></p>
                
                <div class="tool-badges">
                    <span class="badge badge-free">100% Free</span>
                    <span class="badge badge-ghl">GoHighLevel Compatible</span>
                    <span class="badge badge-instant">Instant Results</span>
                </div>
            </div>
        </section>
        
        <!-- Tool Interface Section -->
        <section class="tool-interface">
            <div class="container">
                <div class="tool-layout">
                    <div class="tool-main">
                        <div class="tool-panel">
                            <h2 class="sr-only"><?php echo htmlspecialchars($toolName); ?> Interface</h2>
                            
                            <!-- CUSTOMIZE: Tool-specific interface goes here -->
                            <div class="form-group">
                                <label for="tool-input">Input Label</label>
                                <input type="text" id="tool-input" placeholder="Enter your input...">
                            </div>
                            
                            <button type="button" class="btn btn-primary" onclick="runTool()">
                                Calculate
                            </button>
                            
                            <div id="tool-results" class="tool-results" style="display: none;">
                                <h3>Results</h3>
                                <div id="results-content"></div>
                                
                                <button type="button" class="btn btn-secondary" onclick="copyResults()">
                                    Copy Results
                                </button>
                            </div>
                        </div>
                        
                        <!-- In-Content Ad Slot -->
                        <?php render_ad_slot('in-content', $adSlots['in-content']); ?>
                        
                        <!-- How It Works Section -->
                        <section class="how-it-works">
                            <h2>How It Works</h2>
                            <div class="steps">
                                <div class="step">
                                    <div class="step-number">1</div>
                                    <div class="step-content">
                                        <h3>Enter Your Data</h3>
                                        <p>Input the required information in the form above.</p>
                                    </div>
                                </div>
                                <div class="step">
                                    <div class="step-number">2</div>
                                    <div class="step-content">
                                        <h3>Get Instant Results</h3>
                                        <p>Our tool processes your data and provides immediate results.</p>
                                    </div>
                                </div>
                                <div class="step">
                                    <div class="step-number">3</div>
                                    <div class="step-content">
                                        <h3>Use in GoHighLevel</h3>
                                        <p>Apply the results directly to your GHL campaigns.</p>
                                    </div>
                                </div>
                            </div>
                        </section>
                    </div>
                    
                    <!-- Sidebar -->
                    <aside class="tool-sidebar">
                        <!-- Related Tools -->
                        <div class="sidebar-section">
                            <h3>Related Tools</h3>
                            <div class="related-tools">
                                <a href="sms-counter" class="related-tool">
                                    <span class="tool-icon">📱</span>
                                    <span class="tool-name">SMS Counter</span>
                                </a>
                                <a href="roi-calculator" class="related-tool">
                                    <span class="tool-icon">💰</span>
                                    <span class="tool-name">ROI Calculator</span>
                                </a>
                                <a href="utm-builder" class="related-tool">
                                    <span class="tool-icon">🔗</span>
                                    <span class="tool-name">UTM Builder</span>
                                </a>
                            </div>
                        </div>
                        
                        <!-- Affiliate Recommendations -->
                        <?php if (!empty($affiliatePartners)): ?>
                        <div class="sidebar-section">
                            <h3>Recommended Tools</h3>
                            <div class="affiliate-recommendations">
                                <?php foreach ($affiliatePartners as $partnerId => $partner): ?>
                                <div class="affiliate-card">
                                    <h4><?php echo htmlspecialchars($partner['name']); ?></h4>
                                    <p><?php echo htmlspecialchars($partner['description']); ?></p>
                                    <?php echo render_affiliate_link($partnerId, [
                                        'classes' => 'btn btn-sm btn-outline',
                                        'tool' => $toolSlug
                                    ]); ?>
                                </div>
                                <?php endforeach; ?>
                            </div>
                            
                            <?php render_affiliate_disclosure_notice(); ?>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Sidebar CTA -->
                        <div class="sidebar-section">
                            <?php render_cta(null, [
                                'variant' => 'sidebar',
                                'placement' => 'sidebar'
                            ]); ?>
                        </div>
                    </aside>
                </div>
            </div>
        </section>
        
        <!-- Use Cases Section -->
        <section class="use-cases">
            <div class="container">
                <h2>Use Cases</h2>
                <div class="use-case-grid">
                    <div class="use-case">
                        <h3>For Agencies</h3>
                        <p>Help your clients optimize their campaigns with data-driven insights.</p>
                    </div>
                    <div class="use-case">
                        <h3>For Business Owners</h3>
                        <p>Make informed decisions about your marketing investments.</p>
                    </div>
                    <div class="use-case">
                        <h3>For Marketers</h3>
                        <p>Improve campaign performance with accurate calculations.</p>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- Pro Tips Section -->
        <section class="pro-tips">
            <div class="container">
                <h2>Pro Tips</h2>
                <div class="tips-grid">
                    <div class="tip">
                        <h3>Tip 1 Title</h3>
                        <p>Pro tip content goes here...</p>
                    </div>
                    <div class="tip">
                        <h3>Tip 2 Title</h3>
                        <p>Pro tip content goes here...</p>
                    </div>
                    <div class="tip">
                        <h3>Tip 3 Title</h3>
                        <p>Pro tip content goes here...</p>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- FAQ Section -->
        <section class="faq-section">
            <div class="container">
                <h2>Frequently Asked Questions</h2>
                <div class="faq-grid">
                    <?php foreach ($faqs as $index => $faq): ?>
                    <div class="faq-item">
                        <h3 class="faq-question"><?php echo htmlspecialchars($faq['question']); ?></h3>
                        <div class="faq-answer">
                            <p><?php echo htmlspecialchars($faq['answer']); ?></p>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
        
        <!-- Main CTA Section -->
        <?php render_cta(null, ['placement' => 'content']); ?>
    </main>
    
    <!-- Bottom Ad Slot -->
    <?php render_ad_slot('bottom', $adSlots['bottom']); ?>
    
    <?php include 'includes/footer.php'; ?>
    
    <!-- JavaScript -->
    <script src="lib/js/consent.js"></script>
    <script src="lib/js/analytics.js"></script>
    
    <script>
        // Tool-specific JavaScript
        function runTool() {
            const input = document.getElementById('tool-input').value;
            
            if (!input.trim()) {
                alert('Please enter some data first.');
                return;
            }
            
            // Track tool usage
            trackToolUsage('<?php echo $toolSlug; ?>', 'calculate', {
                input_length: input.length
            });
            
            // CUSTOMIZE: Tool calculation logic here
            const results = processInput(input);
            displayResults(results);
        }
        
        function processInput(input) {
            // CUSTOMIZE: Replace with actual tool logic
            return {
                input: input,
                result: 'Processed: ' + input
            };
        }
        
        function displayResults(results) {
            const resultsDiv = document.getElementById('tool-results');
            const contentDiv = document.getElementById('results-content');
            
            contentDiv.innerHTML = `
                <div class="result-item">
                    <label>Input:</label>
                    <span>${results.input}</span>
                </div>
                <div class="result-item">
                    <label>Result:</label>
                    <span>${results.result}</span>
                </div>
            `;
            
            resultsDiv.style.display = 'block';
            
            // Track successful calculation
            track('tool_calculation', {
                tool_name: '<?php echo $toolSlug; ?>',
                success: true
            });
        }
        
        function copyResults() {
            const resultsText = document.getElementById('results-content').textContent;
            
            if (navigator.clipboard) {
                navigator.clipboard.writeText(resultsText).then(() => {
                    // Track copy action
                    document.dispatchEvent(new CustomEvent('copyToClipboard', {
                        detail: {
                            type: 'tool_results',
                            content: resultsText
                        }
                    }));
                    
                    alert('Results copied to clipboard!');
                }).catch(err => {
                    console.error('Failed to copy: ', err);
                    fallbackCopy(resultsText);
                });
            } else {
                fallbackCopy(resultsText);
            }
        }
        
        function fallbackCopy(text) {
            const textArea = document.createElement('textarea');
            textArea.value = text;
            document.body.appendChild(textArea);
            textArea.select();
            
            try {
                document.execCommand('copy');
                alert('Results copied to clipboard!');
            } catch (err) {
                alert('Failed to copy. Please copy manually.');
            }
            
            document.body.removeChild(textArea);
        }
        
        // FAQ accordion
        document.querySelectorAll('.faq-question').forEach(question => {
            question.addEventListener('click', function() {
                const item = this.parentElement;
                const answer = item.querySelector('.faq-answer');
                const isOpen = item.classList.contains('open');
                
                // Close all other items
                document.querySelectorAll('.faq-item').forEach(otherItem => {
                    if (otherItem !== item) {
                        otherItem.classList.remove('open');
                    }
                });
                
                // Toggle current item
                item.classList.toggle('open', !isOpen);
            });
        });
        
        // Track page view
        track('page_view', {
            page_type: 'tool',
            tool_name: '<?php echo $toolSlug; ?>'
        });
        
        // Track tool interaction
        document.addEventListener('DOMContentLoaded', function() {
            const toolInput = document.getElementById('tool-input');
            if (toolInput) {
                toolInput.addEventListener('input', debounce(function() {
                    track('tool_interaction', {
                        tool_name: '<?php echo $toolSlug; ?>',
                        action: 'input_change',
                        input_length: this.value.length
                    });
                }, 1000));
            }
        });
        
        // Debounce function
        function debounce(func, wait) {
            let timeout;
            return function executedFunction(...args) {
                const later = () => {
                    clearTimeout(timeout);
                    func(...args);
                };
                clearTimeout(timeout);
                timeout = setTimeout(later, wait);
            };
        }
    </script>
    
    <!-- Tool-specific styles -->
    <style>
        .tool-hero {
            background: linear-gradient(135deg, var(--color-primary-50) 0%, var(--color-primary-100) 100%);
            padding: var(--space-12) 0;
        }
        
        .breadcrumb {
            font-size: var(--font-size-sm);
            color: var(--color-neutral-600);
            margin-bottom: var(--space-4);
        }
        
        .breadcrumb a {
            color: var(--color-primary-600);
            text-decoration: none;
        }
        
        .breadcrumb span {
            margin: 0 var(--space-2);
        }
        
        .tool-title {
            font-size: var(--font-size-4xl);
            font-weight: var(--font-weight-bold);
            margin-bottom: var(--space-4);
            color: var(--color-neutral-900);
        }
        
        .tool-subtitle {
            font-size: var(--font-size-xl);
            color: var(--color-neutral-700);
            margin-bottom: var(--space-6);
            max-width: 600px;
        }
        
        .tool-badges {
            display: flex;
            gap: var(--space-3);
            flex-wrap: wrap;
        }
        
        .badge {
            padding: var(--space-2) var(--space-4);
            border-radius: var(--radius-full);
            font-size: var(--font-size-sm);
            font-weight: var(--font-weight-medium);
        }
        
        .badge-free {
            background: var(--color-success);
            color: white;
        }
        
        .badge-ghl {
            background: var(--color-info);
            color: white;
        }
        
        .badge-instant {
            background: var(--color-warning);
            color: white;
        }
        
        .tool-interface {
            padding: var(--space-16) 0;
        }
        
        .tool-layout {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: var(--space-12);
        }
        
        .tool-panel {
            background: white;
            padding: var(--space-8);
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-base);
            border: var(--card-border);
        }
        
        .tool-results {
            margin-top: var(--space-6);
            padding: var(--space-6);
            background: var(--color-neutral-50);
            border-radius: var(--radius-lg);
        }
        
        .result-item {
            display: flex;
            justify-content: space-between;
            padding: var(--space-2) 0;
            border-bottom: 1px solid var(--color-neutral-200);
        }
        
        .result-item:last-child {
            border-bottom: none;
        }
        
        .result-item label {
            font-weight: var(--font-weight-medium);
            color: var(--color-neutral-700);
        }
        
        .tool-sidebar {
            display: flex;
            flex-direction: column;
            gap: var(--space-8);
        }
        
        .sidebar-section {
            background: white;
            padding: var(--space-6);
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-base);
            border: var(--card-border);
        }
        
        .sidebar-section h3 {
            margin-bottom: var(--space-4);
            font-size: var(--font-size-lg);
            color: var(--color-neutral-900);
        }
        
        .related-tools {
            display: flex;
            flex-direction: column;
            gap: var(--space-3);
        }
        
        .related-tool {
            display: flex;
            align-items: center;
            gap: var(--space-3);
            padding: var(--space-3);
            border-radius: var(--radius-base);
            text-decoration: none;
            color: var(--color-neutral-700);
            transition: var(--transition-base);
        }
        
        .related-tool:hover {
            background: var(--color-neutral-50);
            color: var(--color-primary-600);
        }
        
        .affiliate-card {
            margin-bottom: var(--space-4);
            padding: var(--space-4);
            border: 1px solid var(--color-neutral-200);
            border-radius: var(--radius-base);
        }
        
        .affiliate-card h4 {
            margin-bottom: var(--space-2);
            font-size: var(--font-size-base);
        }
        
        .affiliate-card p {
            font-size: var(--font-size-sm);
            color: var(--color-neutral-600);
            margin-bottom: var(--space-3);
        }
        
        .how-it-works,
        .use-cases,
        .pro-tips,
        .faq-section {
            padding: var(--space-16) 0;
        }
        
        .how-it-works h2,
        .use-cases h2,
        .pro-tips h2,
        .faq-section h2 {
            text-align: center;
            margin-bottom: var(--space-12);
            font-size: var(--font-size-3xl);
        }
        
        .steps {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: var(--space-8);
        }
        
        .step {
            text-align: center;
        }
        
        .step-number {
            width: 60px;
            height: 60px;
            background: var(--color-primary-500);
            color: white;
            border-radius: var(--radius-full);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: var(--font-size-2xl);
            font-weight: var(--font-weight-bold);
            margin: 0 auto var(--space-4);
        }
        
        .use-case-grid,
        .tips-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: var(--space-8);
        }
        
        .use-case,
        .tip {
            padding: var(--space-6);
            background: white;
            border-radius: var(--radius-xl);
            box-shadow: var(--shadow-base);
            border: var(--card-border);
        }
        
        .faq-grid {
            max-width: 800px;
            margin: 0 auto;
        }
        
        .faq-item {
            border-bottom: 1px solid var(--color-neutral-200);
            padding: var(--space-6) 0;
        }
        
        .faq-question {
            cursor: pointer;
            margin: 0;
            font-size: var(--font-size-lg);
            color: var(--color-neutral-900);
        }
        
        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height var(--transition-base);
        }
        
        .faq-item.open .faq-answer {
            max-height: 200px;
            margin-top: var(--space-4);
        }
        
        @media (max-width: 768px) {
            .tool-layout {
                grid-template-columns: 1fr;
            }
            
            .tool-title {
                font-size: var(--font-size-3xl);
            }
            
            .tool-badges {
                justify-content: center;
            }
        }
    </style>
</body>
</html>