<?php
/**
 * Affiliate Panels Component for GHL Toolset
 * Provides placeholder affiliate blocks and GHL affiliate card
 */

/**
 * Render affiliate panel with placeholder cards
 * 
 * @param array $options Configuration options
 */
function render_affiliate_panel($options = []) {
    $title = $options['title'] ?? 'Recommended Tools & Services';
    $note = $options['note'] ?? 'These are placeholder affiliate cards. Replace with your own affiliate offers.';
    $cardCount = $options['card_count'] ?? 3;
    
    echo '<section class="affiliate-section">';
    echo '<div class="container">';
    echo '<div class="content-card">';
    echo '<h2>' . htmlspecialchars($title) . '</h2>';
    echo '<p class="affiliate-note">' . htmlspecialchars($note) . '</p>';
    
    echo '<div class="affiliate-grid">';
    
    // Render placeholder cards
    for ($i = 1; $i <= $cardCount; $i++) {
        echo '<div class="affiliate-placeholder-card">';
        echo '<div class="affiliate-icon">🔧</div>';
        echo '<h3>Affiliate Partner ' . $i . '</h3>';
        echo '<p>This is a placeholder for your affiliate offer. Replace with actual partner information and affiliate links.</p>';
        echo '<div class="affiliate-features">';
        echo '<ul>';
        echo '<li>Feature 1 placeholder</li>';
        echo '<li>Feature 2 placeholder</li>';
        echo '<li>Feature 3 placeholder</li>';
        echo '</ul>';
        echo '</div>';
        echo '<a href="#" class="btn btn-outline affiliate-btn">Visit Partner (Placeholder)</a>';
        echo '<span class="affiliate-badge">Placeholder</span>';
        echo '</div>';
    }
    
    echo '</div>'; // affiliate-grid
    echo '</div>'; // content-card
    echo '</div>'; // container
    echo '</section>'; // affiliate-section
}

/**
 * Render GoHighLevel affiliate card
 */
function render_ghl_affiliate_card() {
    echo '<section class="ghl-affiliate-section">';
    echo '<div class="container">';
    echo '<div class="content-card">';
    echo '<h2>Ready to Upgrade Your GoHighLevel Experience?</h2>';
    echo '<p>Take your GHL setup to the next level with professional optimization and training.</p>';
    
    echo '<div class="ghl-affiliate-card">';
    echo '<div class="ghl-header">';
    echo '<div class="ghl-icon">🚀</div>';
    echo '<div class="ghl-title">';
    echo '<h3>GoHighLevel Premium Training</h3>';
    echo '<p class="ghl-subtitle">Master GHL with Expert Guidance</p>';
    echo '</div>';
    echo '</div>';
    
    echo '<div class="ghl-content">';
    echo '<div class="ghl-features">';
    echo '<ul>';
    echo '<li>✅ Complete GHL Setup & Optimization</li>';
    echo '<li>✅ Advanced Automation Workflows</li>';
    echo '<li>✅ Custom Funnel Development</li>';
    echo '<li>✅ Pipeline & Lead Management</li>';
    echo '<li>✅ Integration & API Setup</li>';
    echo '<li>✅ Ongoing Support & Updates</li>';
    echo '</ul>';
    echo '</div>';
    
    echo '<div class="ghl-pricing">';
    echo '<div class="price-tag">';
    echo '<span class="price-amount">Starting at $497</span>';
    echo '<span class="price-period">one-time</span>';
    echo '</div>';
    echo '<div class="value-proposition">';
    echo '<span class="savings">Save 40+ hours of setup time</span>';
    echo '</div>';
    echo '</div>';
    echo '</div>';
    
    echo '<div class="ghl-actions">';
    // Use fallback URL if affiliate system not available
    if (function_exists('affiliate_url')) {
        $affiliateUrl = affiliate_url('ghl', [
            'utm_source' => 'ghl-toolset',
            'utm_medium' => 'affiliate-card',
            'utm_campaign' => 'ghl-training'
        ]);
    } else {
        $affiliateUrl = BOOKING_URL . '?' . http_build_query([
            'utm_source' => 'ghl-toolset',
            'utm_medium' => 'affiliate-card',
            'utm_campaign' => 'ghl-training'
        ]);
    }
    
    echo '<a href="' . htmlspecialchars($affiliateUrl) . '" class="btn btn-primary btn-lg ghl-cta" target="_blank" rel="nofollow">';
    echo 'Get Professional GHL Setup';
    echo '</a>';
    
    echo '<p class="ghl-guarantee">30-day money-back guarantee</p>';
    echo '</div>';
    
    echo '</div>'; // ghl-affiliate-card
    
    // Affiliate disclosure
    echo '<div class="affiliate-disclosure">';
    echo '<p><small><em>Disclosure: This is an affiliate link. We may earn a commission if you purchase through this link, at no additional cost to you. We only recommend services we genuinely believe provide value to our users.</em></small></p>';
    echo '</div>';
    
    echo '</div>'; // content-card
    echo '</div>'; // container
    echo '</section>'; // ghl-affiliate-section
}

/**
 * Render affiliate section styles (inline CSS)
 */
function render_affiliate_styles() {
    echo '<style>';
    echo '.affiliate-section, .ghl-affiliate-section { padding: var(--space-16) 0; background: var(--color-neutral-50); }';
    echo '.affiliate-note { color: var(--color-warning-700); background: var(--color-warning-50); padding: var(--space-4); border-radius: var(--radius-lg); margin-bottom: var(--space-8); border-left: 4px solid var(--color-warning-500); }';
    echo '.affiliate-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: var(--space-6); margin-top: var(--space-8); }';
    echo '.affiliate-placeholder-card { background: white; padding: var(--space-6); border-radius: var(--radius-xl); box-shadow: var(--shadow-base); border: 2px dashed var(--color-neutral-300); position: relative; }';
    echo '.affiliate-placeholder-card .affiliate-icon { font-size: var(--font-size-3xl); margin-bottom: var(--space-4); }';
    echo '.affiliate-placeholder-card h3 { margin-bottom: var(--space-3); color: var(--color-neutral-700); }';
    echo '.affiliate-placeholder-card p { color: var(--color-neutral-600); margin-bottom: var(--space-4); }';
    echo '.affiliate-features ul { list-style: none; padding: 0; margin-bottom: var(--space-6); }';
    echo '.affiliate-features li { padding: var(--space-1) 0; color: var(--color-neutral-600); }';
    echo '.affiliate-badge { position: absolute; top: var(--space-3); right: var(--space-3); background: var(--color-warning-500); color: white; padding: var(--space-1) var(--space-2); border-radius: var(--radius-base); font-size: var(--font-size-xs); font-weight: var(--font-weight-bold); }';
    
    // GHL Affiliate Card Styles
    echo '.ghl-affiliate-card { background: linear-gradient(135deg, var(--color-primary-50) 0%, var(--color-primary-100) 100%); padding: var(--space-8); border-radius: var(--radius-2xl); border: 1px solid var(--color-primary-200); }';
    echo '.ghl-header { display: flex; align-items: center; gap: var(--space-4); margin-bottom: var(--space-6); }';
    echo '.ghl-icon { font-size: var(--font-size-4xl); }';
    echo '.ghl-title h3 { margin: 0; color: var(--color-primary-900); font-size: var(--font-size-2xl); }';
    echo '.ghl-subtitle { margin: 0; color: var(--color-primary-700); font-size: var(--font-size-base); }';
    echo '.ghl-content { display: grid; grid-template-columns: 1fr auto; gap: var(--space-8); margin-bottom: var(--space-6); }';
    echo '.ghl-features ul { list-style: none; padding: 0; margin: 0; }';
    echo '.ghl-features li { padding: var(--space-2) 0; color: var(--color-primary-800); }';
    echo '.ghl-pricing { text-align: center; }';
    echo '.price-tag { margin-bottom: var(--space-2); }';
    echo '.price-amount { display: block; font-size: var(--font-size-3xl); font-weight: var(--font-weight-bold); color: var(--color-primary-900); }';
    echo '.price-period { color: var(--color-primary-600); }';
    echo '.savings { color: var(--color-success-700); font-weight: var(--font-weight-medium); font-size: var(--font-size-sm); }';
    echo '.ghl-actions { text-align: center; }';
    echo '.ghl-cta { margin-bottom: var(--space-3); }';
    echo '.ghl-guarantee { color: var(--color-primary-600); font-size: var(--font-size-sm); margin: 0; }';
    echo '.affiliate-disclosure { margin-top: var(--space-6); padding-top: var(--space-4); border-top: 1px solid var(--color-neutral-200); }';
    
    // Responsive
    echo '@media (max-width: 768px) {';
    echo '  .affiliate-grid { grid-template-columns: 1fr; }';
    echo '  .ghl-content { grid-template-columns: 1fr; text-align: center; }';
    echo '  .ghl-header { text-align: center; flex-direction: column; }';
    echo '}';
    echo '</style>';
}
?>
