﻿<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Template Builder for GoHighLevel | Free Email Design Tool</title>
    <meta name="description" content="Free email template builder for GoHighLevel users. Create professional email templates for your campaigns with drag-and-drop functionality. Perfect for agencies managing email marketing.">
    <meta name="keywords" content="email template builder, email design tool, GoHighLevel agency, email marketing, email templates, campaign emails, professional emails, email builder">
    <meta name="author" content="Paddle CRM">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="Email Template Builder for GoHighLevel">
    <meta property="og:description" content="Free email template builder for GoHighLevel users. Create professional email templates for your campaigns.">
    <meta property="og:url" content="https://yourdomain.com/email-template-builder.php">
    <meta property="og:image" content="https://yourdomain.com/images/email-template-builder-og.jpg">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="Email Template Builder for GoHighLevel">
    <meta property="twitter:description" content="Free email template builder for GoHighLevel users. Create professional email templates for your campaigns.">
    <meta property="twitter:image" content="https://yourdomain.com/images/email-template-builder-og.jpg">
    
    <!-- Schema.org structured data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Email Template Builder for GoHighLevel",
        "description": "Free tool to create professional email templates for marketing campaigns and business communications",
        "url": "https://yourdomain.com/email-template-builder.php",
        "applicationCategory": "BusinessApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Paddle CRM",
            "description": "WhiteLabel GoHighLevel Agency"
        }
    }
    </script>
    
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php inc('includes/header.php'); ?>

    <!-- Hero Section -->
    <section class="hero tool-hero">
        <div class="container">
            <nav class="breadcrumb">
                <a href="index.php">Home</a> > <span>Email Template Builder</span>
            </nav>
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">Email Template Builder for GoHighLevel</h1>
                    <p class="hero-subtitle">Create professional email templates for your campaigns with our intuitive drag-and-drop builder</p>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <span class="stat-number">Professional</span>
                            <span class="stat-label">Quality</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">GoHighLevel</span>
                            <span class="stat-label">Optimized</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Free Tool</span>
                        </div>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-image">
                        <div class="floating-card card-1">
                            <span class="card-icon">📧</span>
                            <span class="card-text">Template</span>
                        </div>
                        <div class="floating-card card-2">
                            <span class="card-icon">⚡</span>
                            <span class="card-text">Fast</span>
                        </div>
                        <div class="floating-card card-3">
                            <span class="card-icon">🎯</span>
                            <span class="card-text">Professional</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Section -->
    <section class="tool-section">
        <div class="container">
            <div class="tool-card featured">
                <div class="tool-header">
                    <div class="tool-icon">📧</div>
                    <h2>Email Template Builder</h2>
                    <p>Professional email design tool designed specifically for GoHighLevel users and agencies</p>
                </div>
                
                <div class="tool-interface">
                    <div class="template-controls">
                        <div class="input-group">
                            <label for="templateType">Template Type</label>
                            <select id="templateType">
                                <option value="">Select Template Type</option>
                                <option value="newsletter">Newsletter</option>
                                <option value="promotional">Promotional</option>
                                <option value="welcome">Welcome Series</option>
                                <option value="nurture">Lead Nurturing</option>
                                <option value="announcement">Company Announcement</option>
                                <option value="product">Product Launch</option>
                                <option value="event">Event Invitation</option>
                                <option value="custom">Custom Template</option>
                            </select>
                        </div>
                        
                        <div class="input-group">
                            <label for="emailSubject">Email Subject Line</label>
                            <input type="text" id="emailSubject" placeholder="Enter your email subject line...">
                        </div>
                        
                        <div class="input-group">
                            <label for="senderName">Sender Name</label>
                            <input type="text" id="senderName" placeholder="Your Company Name">
                        </div>
                        
                        <div class="input-group">
                            <label for="senderEmail">Sender Email</label>
                            <input type="email" id="senderEmail" placeholder="noreply@yourcompany.com">
                        </div>
                    </div>
                    
                    <div class="template-builder">
                        <div class="builder-toolbar">
                            <button class="btn btn-secondary" onclick="addHeader()">Add Header</button>
                            <button class="btn btn-secondary" onclick="addTextBlock()">Add Text</button>
                            <button class="btn btn-secondary" onclick="addImage()">Add Image</button>
                            <button class="btn btn-secondary" onclick="addButton()">Add Button</button>
                            <button class="btn btn-secondary" onclick="addDivider()">Add Divider</button>
                            <button class="btn btn-secondary" onclick="addFooter()">Add Footer</button>
                        </div>
                        
                        <div class="email-preview" id="emailPreview">
                            <div class="email-container">
                                <div class="email-header">
                                    <h2>Email Template Preview</h2>
                                    <p>Use the toolbar above to build your email template</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="button-group">
                        <button class="btn btn-primary" onclick="previewTemplate()">Preview Template</button>
                        <button class="btn btn-secondary" onclick="exportTemplate()">Export Template</button>
                        <button class="btn btn-secondary" onclick="saveTemplate()">Save Template</button>
                        <button class="btn btn-secondary" onclick="clearTemplate()">Clear Template</button>
                    </div>
                    
                    <div class="result" id="templateResult" style="display: none;">
                        <h3>Generated Email Template</h3>
                        <div class="template-output" id="templateOutput"></div>
                        <div class="template-actions">
                            <button class="btn btn-primary" onclick="copyTemplate()">Copy HTML</button>
                            <button class="btn btn-secondary" onclick="downloadTemplate()">Download HTML</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Content Section -->
    <section class="content-section">
        <div class="container">
            <div class="content-grid">
                <article class="content-card">
                    <h2>What is an Email Template Builder?</h2>
                    <p>An email template builder is a tool that allows marketers and agencies to create professional, responsive email templates without needing coding knowledge. It provides pre-built components, drag-and-drop functionality, and customization options to design emails that drive engagement and conversions.</p>
                    
                    <p>For GoHighLevel users, professional email templates are crucial for:</p>
                    <ul>
                        <li><strong>Brand Consistency:</strong> Maintaining uniform appearance across all client communications</li>
                        <li><strong>Professional Appearance:</strong> Ensuring all emails meet industry standards</li>
                        <li><strong>Engagement Optimization:</strong> Creating emails that encourage opens, clicks, and conversions</li>
                        <li><strong>Time Efficiency:</strong> Building templates quickly for multiple clients</li>
                        <li><strong>Mobile Optimization:</strong> Ensuring emails work perfectly on all devices</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Why GoHighLevel Users Need This Tool</h2>
                    <p>As a GoHighLevel agency, you're managing email campaigns for multiple clients across various industries. Each client needs unique, professional email templates that reflect their brand and drive results.</p>
                    
                    <ul>
                        <li><strong>Multi-Client Management:</strong> Create unique templates for each client efficiently</li>
                        <li><strong>Brand Customization:</strong> Adapt templates to match client brand guidelines</li>
                        <li><strong>Professional Quality:</strong> Ensure all client emails meet industry standards</li>
                        <li><strong>Time Savings:</strong> Build templates quickly without coding knowledge</li>
                        <li><strong>Consistency Management:</strong> Maintain uniform email appearance across campaigns</li>
                        <li><strong>Client Satisfaction:</strong> Deliver professional email designs that clients love</li>
                        <li><strong>Service Expansion:</strong> Add email design as a premium service offering</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>How to Use the Email Template Builder</h2>
                    <p>Our email template builder is designed to be intuitive and powerful:</p>
                    
                    <ol>
                        <li><strong>Select Template Type:</strong> Choose the type of email you're creating</li>
                        <li><strong>Set Email Details:</strong> Enter subject line, sender name, and email</li>
                        <li><strong>Build Your Template:</strong> Use the toolbar to add components:
                            <ul>
                                <li><strong>Header:</strong> Company logo and navigation</li>
                                <li><strong>Text Blocks:</strong> Content sections with formatting</li>
                                <li><strong>Images:</strong> Visual elements and graphics</li>
                                <li><strong>Buttons:</strong> Call-to-action elements</li>
                                <li><strong>Dividers:</strong> Visual separators</li>
                                <li><strong>Footer:</strong> Contact information and links</li>
                            </ul>
                        </li>
                        <li><strong>Preview & Test:</strong> See how your email looks before sending</li>
                        <li><strong>Export & Use:</strong> Download HTML or copy code for use in GHL</li>
                    </ol>
                </article>

                <article class="content-card">
                    <h2>Use Cases for GoHighLevel Agencies</h2>
                    <p>This tool serves multiple purposes in your daily GoHighLevel operations:</p>
                    
                    <ul>
                        <li><strong>Client Email Campaigns:</strong> Create templates for client marketing campaigns</li>
                        <li><strong>Welcome Series:</strong> Design onboarding email sequences</li>
                        <li><strong>Newsletter Templates:</strong> Build consistent newsletter designs</li>
                        <li><strong>Promotional Emails:</strong> Create sales and promotional templates</li>
                        <li><strong>Event Communications:</strong> Design event invitation and reminder emails</li>
                        <li><strong>Product Launches:</strong> Create announcement and launch emails</li>
                        <li><strong>Lead Nurturing:</strong> Design educational and nurturing sequences</li>
                        <li><strong>Brand Templates:</strong> Create reusable brand templates for clients</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Email Design Best Practices</h2>
                    <p>To create effective email templates, follow these proven design principles:</p>
                    
                    <ul>
                        <li><strong>Mobile-First Design:</strong> Ensure emails look great on mobile devices</li>
                        <li><strong>Clear Hierarchy:</strong> Use typography and spacing to guide the eye</li>
                        <li><strong>Strong CTAs:</strong> Make call-to-action buttons prominent and clear</li>
                        <li><strong>Consistent Branding:</strong> Maintain brand colors, fonts, and imagery</li>
                        <li><strong>Readable Typography:</strong> Use fonts and sizes that are easy to read</li>
                        <li><strong>Visual Balance:</strong> Create harmonious layouts with proper spacing</li>
                        <li><strong>Accessibility:</strong> Ensure emails are accessible to all users</li>
                        <li><strong>Testing:</strong> Test emails across different email clients</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Integration with GoHighLevel</h2>
                    <p>This tool integrates seamlessly with your GoHighLevel workflow:</p>
                    
                    <ul>
                        <li><strong>Email Campaigns:</strong> Use generated templates in GHL email campaigns</li>
                        <li><strong>Automation Sequences:</strong> Apply templates to automated email flows</li>
                        <li><strong>Template Library:</strong> Build a collection of reusable templates</li>
                        <li><strong>Client Branding:</strong> Create branded templates for each client</li>
                        <li><strong>Campaign Management:</strong> Use templates across multiple campaigns</li>
                        <li><strong>Performance Tracking:</strong> Monitor template performance in GHL analytics</li>
                        <li><strong>Client Deliverables:</strong> Provide professional templates as client deliverables</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Email Template Components</h2>
                    <p>Understanding these components helps you build effective email templates:</p>
                    
                    <ul>
                        <li><strong>Header Section:</strong> Logo, navigation, and brand identification</li>
                        <li><strong>Hero Area:</strong> Main message and primary call-to-action</li>
                        <li><strong>Content Blocks:</strong> Text, images, and information sections</li>
                        <li><strong>Call-to-Action:</strong> Buttons and links that drive action</li>
                        <li><strong>Social Proof:</strong> Testimonials, reviews, and social signals</li>
                        <li><strong>Footer Section:</strong> Contact info, unsubscribe, and legal links</li>
                        <li><strong>Personalization:</strong> Dynamic content based on recipient data</li>
                        <li><strong>Responsive Elements:</strong> Components that adapt to different screen sizes</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Advanced Email Strategies</h2>
                    <p>Beyond basic template creation, consider these advanced strategies:</p>
                    
                    <ul>
                        <li><strong>Segmentation Templates:</strong> Create different templates for different audience segments</li>
                        <li><strong>Behavioral Triggers:</strong> Design templates for specific user actions</li>
                        <li><strong>Seasonal Variations:</strong> Adapt templates for holidays and seasons</li>
                        <li><strong>Personalization:</strong> Use dynamic content to personalize emails</li>
                        <li><strong>A/B Testing:</strong> Test different template variations for better performance</li>
                        <li><strong>Accessibility Features:</strong> Ensure emails work for users with disabilities</li>
                        <li><strong>Internationalization:</strong> Adapt templates for different languages and cultures</li>
                    </ul>
                </article>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="related-tools">
        <div class="container">
            <h2>Related GoHighLevel Tools</h2>
            <div class="tools-grid">
                <a href="email-subject-line-scorer.php" class="tool-link">
                    <div class="tool-icon">📧</div>
                    <h3>Email Subject Line Scorer</h3>
                    <p>Optimize your email subject lines for better open rates</p>
                </a>
                <a href="social-media-caption-generator.php" class="tool-link">
                    <div class="tool-icon">📱</div>
                    <h3>Social Media Caption Generator</h3>
                    <p>Generate engaging social media content</p>
                </a>
                <a href="content-readability-scorer.php" class="tool-link">
                    <div class="tool-icon">📖</div>
                    <h3>Content Readability Scorer</h3>
                    <p>Analyze and improve your content readability</p>
                </a>
            </div>
        </div>
    </section>

    <?php inc('includes/footer.php'); ?>
    <script src="common.js"></script>
    <script>`n    `n    // Load footer`n    fetch("footer.php")`n        .then(response => response.text())`n        .then(data => {`n            document.getElementById("footer-placeholder").innerHTML = data;`n        });`n});`n`n
        // Email Template Builder functionality
        let templateComponents = [];
        let componentCounter = 0;

        function addHeader() {
            const header = {
                id: componentCounter++,
                type: 'header',
                content: {
                    logo: 'Your Company Logo',
                    tagline: 'Your Company Tagline',
                    backgroundColor: '#0a2038',
                    textColor: '#ffffff'
                }
            };
            templateComponents.push(header);
            renderTemplate();
        }

        function addTextBlock() {
            const textBlock = {
                id: componentCounter++,
                type: 'text',
                content: {
                    heading: 'Your Heading Here',
                    body: 'Your content goes here. This is where you can add your main message, product information, or any other content you want to share with your subscribers.',
                    backgroundColor: '#ffffff',
                    textColor: '#333333'
                }
            };
            templateComponents.push(textBlock);
            renderTemplate();
        }

        function addImage() {
            const image = {
                id: componentCounter++,
                type: 'image',
                content: {
                    src: 'https://via.placeholder.com/600x300',
                    alt: 'Image Description',
                    width: '600',
                    height: '300',
                    alignment: 'center'
                }
            };
            templateComponents.push(image);
            renderTemplate();
        }

        function addButton() {
            const button = {
                id: componentCounter++,
                type: 'button',
                content: {
                    text: 'Click Here',
                    url: '#',
                    backgroundColor: '#007bff',
                    textColor: '#ffffff',
                    alignment: 'center'
                }
            };
            templateComponents.push(button);
            renderTemplate();
        }

        function addDivider() {
            const divider = {
                id: componentCounter++,
                type: 'divider',
                content: {
                    color: '#dddddd',
                    height: '1px',
                    margin: '20px 0'
                }
            };
            templateComponents.push(divider);
            renderTemplate();
        }

        function addFooter() {
            const footer = {
                id: componentCounter++,
                type: 'footer',
                content: {
                    companyName: 'Your Company Name',
                    address: '123 Business St, City, State 12345',
                    phone: '(555) 123-4567',
                    email: 'info@yourcompany.com',
                    backgroundColor: '#f8f9fa',
                    textColor: '#666666'
                }
            };
            templateComponents.push(footer);
            renderTemplate();
        }

        function renderTemplate() {
            const preview = document.getElementById('emailPreview');
            let html = '<div class="email-container">';
            
            templateComponents.forEach(component => {
                html += renderComponent(component);
            });
            
            html += '</div>';
            preview.innerHTML = html;
        }

        function renderComponent(component) {
            switch(component.type) {
                case 'header':
                    return `
                        <div class="email-header" style="background-color: ${component.content.backgroundColor}; color: ${component.content.textColor}; padding: 20px; text-align: center;">
                            <h1 style="margin: 0; font-size: 24px;">${component.content.logo}</h1>
                            <p style="margin: 10px 0 0 0; font-size: 16px;">${component.content.tagline}</p>
                        </div>
                    `;
                case 'text':
                    return `
                        <div class="email-text" style="background-color: ${component.content.backgroundColor}; color: ${component.content.textColor}; padding: 30px; text-align: left;">
                            <h2 style="margin: 0 0 15px 0; font-size: 20px;">${component.content.heading}</h2>
                            <p style="margin: 0; line-height: 1.6; font-size: 16px;">${component.content.body}</p>
                        </div>
                    `;
                case 'image':
                    return `
                        <div class="email-image" style="text-align: ${component.content.alignment}; padding: 20px;">
                            <img src="${component.content.src}" alt="${component.content.alt}" style="max-width: 100%; height: auto;">
                        </div>
                    `;
                case 'button':
                    return `
                        <div class="email-button" style="text-align: ${component.content.alignment}; padding: 20px;">
                            <a href="${component.content.url}" style="display: inline-block; background-color: ${component.content.backgroundColor}; color: ${component.content.textColor}; padding: 12px 30px; text-decoration: none; border-radius: 5px; font-weight: 600;">${component.content.text}</a>
                        </div>
                    `;
                case 'divider':
                    return `
                        <div class="email-divider" style="margin: ${component.content.margin};">
                            <hr style="border: none; height: ${component.content.height}; background-color: ${component.content.color};">
                        </div>
                    `;
                case 'footer':
                    return `
                        <div class="email-footer" style="background-color: ${component.content.backgroundColor}; color: ${component.content.textColor}; padding: 30px; text-align: center;">
                            <h3 style="margin: 0 0 15px 0; font-size: 18px;">${component.content.companyName}</h3>
                            <p style="margin: 5px 0; font-size: 14px;">${component.content.address}</p>
                            <p style="margin: 5px 0; font-size: 14px;">Phone: ${component.content.phone}</p>
                            <p style="margin: 5px 0; font-size: 14px;">Email: ${component.content.email}</p>
                        </div>
                    `;
                default:
                    return '';
            }
        }

        function previewTemplate() {
            if (templateComponents.length === 0) {
                alert('Please add some components to your template first');
                return;
            }
            
            const subject = document.getElementById('emailSubject').value || 'Your Email Subject';
            const senderName = document.getElementById('senderName').value || 'Your Company';
            const senderEmail = document.getElementById('senderEmail').value || 'noreply@yourcompany.com';
            
            let html = generateHTMLTemplate(subject, senderName, senderEmail);
            
            document.getElementById('templateOutput').innerHTML = `
                <div class="template-preview">
                    <h4>Email Details:</h4>
                    <p><strong>Subject:</strong> ${subject}</p>
                    <p><strong>From:</strong> ${senderName} &lt;${senderEmail}&gt;</p>
                    
                    <h4>Template Preview:</h4>
                    <div class="email-preview-frame">
                        ${html}
                    </div>
                </div>
            `;
            
            document.getElementById('templateResult').style.display = 'block';
        }

        function generateHTMLTemplate(subject, senderName, senderEmail) {
            let html = `
                <!DOCTYPE html>
                <html lang="en">
                <head>
                    <meta charset="UTF-8">
                    <meta name="viewport" content="width=device-width, initial-scale=1.0">
                    <title>${subject}</title>
                    <style>
                        body { margin: 0; padding: 0; font-family: Arial, sans-serif; }
                        .email-container { max-width: 600px; margin: 0 auto; }
                        @media only screen and (max-width: 600px) {
                            .email-container { width: 100% !important; }
                        }
                    </style>
                </head>
                <body>
                    <div class="email-container">
            `;
            
            templateComponents.forEach(component => {
                html += renderComponent(component);
            });
            
            html += `
                    </div>
                </body>
                </html>
            `;
            
            return html;
        }

        function exportTemplate() {
            previewTemplate();
        }

        function saveTemplate() {
            if (templateComponents.length === 0) {
                alert('Please add some components to your template first');
                return;
            }
            
            const templateData = {
                name: document.getElementById('templateType').value || 'Custom Template',
                subject: document.getElementById('emailSubject').value || 'Your Email Subject',
                senderName: document.getElementById('senderName').value || 'Your Company',
                senderEmail: document.getElementById('senderEmail').value || 'noreply@yourcompany.com',
                components: templateComponents,
                timestamp: new Date().toISOString()
            };
            
            const dataStr = JSON.stringify(templateData, null, 2);
            const dataBlob = new Blob([dataStr], {type: 'application/json'});
            
            const link = document.createElement('a');
            link.href = URL.createObjectURL(dataBlob);
            link.download = 'email-template.json';
            link.click();
        }

        function clearTemplate() {
            templateComponents = [];
            componentCounter = 0;
            renderTemplate();
            document.getElementById('templateResult').style.display = 'none';
        }

        function copyTemplate() {
            const templateOutput = document.getElementById('templateOutput');
            const htmlContent = templateOutput.querySelector('.email-preview-frame').innerHTML;
            
            navigator.clipboard.writeText(htmlContent).then(function() {
                alert('Template HTML copied to clipboard!');
            }).catch(function(err) {
                console.error('Could not copy template: ', err);
                alert('Failed to copy template. Please select and copy manually.');
            });
        }

        function downloadTemplate() {
            const templateOutput = document.getElementById('templateOutput');
            const htmlContent = templateOutput.querySelector('.email-preview-frame').innerHTML;
            
            const dataBlob = new Blob([htmlContent], {type: 'text/html'});
            const link = document.createElement('a');
            link.href = URL.createObjectURL(dataBlob);
            link.download = 'email-template.php';
            link.click();
        }

        // Template type change handler
        document.getElementById('templateType').addEventListener('change', function() {
            const templateType = this.value;
            if (templateType && templateComponents.length === 0) {
                // Auto-populate based on template type
                switch(templateType) {
                    case 'newsletter':
                        addHeader();
                        addTextBlock();
                        addImage();
                        addButton();
                        addFooter();
                        break;
                    case 'promotional':
                        addHeader();
                        addTextBlock();
                        addButton();
                        addTextBlock();
                        addFooter();
                        break;
                    case 'welcome':
                        addHeader();
                        addTextBlock();
                        addButton();
                        addFooter();
                        break;
                }
            }
        });
    </script>

    <style>
        .template-controls {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 20px;
            margin-bottom: 20px;
        }

        .template-builder {
            border: 1px solid #ddd;
            border-radius: 8px;
            overflow: hidden;
            margin-bottom: 20px;
        }

        .builder-toolbar {
            background: #f8f9fa;
            padding: 15px;
            border-bottom: 1px solid #ddd;
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }

        .email-preview {
            background: white;
            min-height: 400px;
            padding: 20px;
        }

        .email-container {
            max-width: 600px;
            margin: 0 auto;
            border: 1px solid #ddd;
            border-radius: 8px;
            overflow: hidden;
        }

        .template-preview {
            background: white;
            padding: 20px;
            border-radius: 8px;
            border: 1px solid #ddd;
        }

        .email-preview-frame {
            border: 1px solid #ddd;
            border-radius: 8px;
            overflow: hidden;
            margin-top: 15px;
        }

        .template-actions {
            margin-top: 20px;
            text-align: center;
        }

        .template-actions .btn {
            margin: 0 10px;
        }

        .email-header, .email-text, .email-image, .email-button, .email-divider, .email-footer {
            margin: 0;
        }

        .email-header h1, .email-text h2, .email-footer h3 {
            font-family: Arial, sans-serif;
        }
    </style>
</body>
</html>




