﻿<?php
require_once __DIR__ . '/config.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Conversion Rate Optimizer for GoHighLevel | Free CRO Tool</title>
    <meta name="description" content="Free conversion rate optimizer for GoHighLevel users. Analyze and optimize your funnel conversion rates with data-driven insights. Perfect for agencies looking to improve client performance.">
    <meta name="keywords" content="conversion rate optimizer, CRO tool, funnel optimization, conversion optimization, GoHighLevel agency, funnel analytics, conversion improvement, marketing optimization">
    <meta name="author" content="Paddle CRM">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph / Facebook -->
    <meta property="og:type" content="website">
    <meta property="og:title" content="Conversion Rate Optimizer for GoHighLevel">
    <meta property="og:description" content="Free conversion rate optimizer for GoHighLevel users. Analyze and optimize your funnel conversion rates.">
    <meta property="og:url" content="https://yourdomain.com/conversion-rate-optimizer.php">
    <meta property="og:image" content="https://yourdomain.com/images/conversion-rate-optimizer-og.jpg">
    
    <!-- Twitter -->
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:title" content="Conversion Rate Optimizer for GoHighLevel">
    <meta property="twitter:description" content="Free conversion rate optimizer for GoHighLevel users. Analyze and optimize your funnel conversion rates.">
    <meta property="twitter:image" content="https://yourdomain.com/images/conversion-rate-optimizer-og.jpg">
    
    <!-- Schema.org structured data -->
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebApplication",
        "name": "Conversion Rate Optimizer for GoHighLevel",
        "description": "Free tool to analyze and optimize conversion rates for marketing funnels and campaigns",
        "url": "https://yourdomain.com/conversion-rate-optimizer.php",
        "applicationCategory": "BusinessApplication",
        "operatingSystem": "Web Browser",
        "offers": {
            "@type": "Offer",
            "price": "0",
            "priceCurrency": "USD"
        },
        "provider": {
            "@type": "Organization",
            "name": "Paddle CRM",
            "description": "WhiteLabel GoHighLevel Agency"
        }
    }
    </script>
    
    <link rel="stylesheet" href="styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <?php inc('includes/header.php'); ?>

    <!-- Hero Section -->
    <section class="hero tool-hero">
        <div class="container">
            <nav class="breadcrumb">
                <a href="index.php">Home</a> > <span>Conversion Rate Optimizer</span>
            </nav>
            <div class="hero-content">
                <div class="hero-text">
                    <h1 class="hero-title">Conversion Rate Optimizer for GoHighLevel</h1>
                    <p class="hero-subtitle">Analyze and optimize your funnel conversion rates with data-driven insights and actionable recommendations</p>
                    <div class="hero-stats">
                        <div class="stat-item">
                            <span class="stat-number">Professional</span>
                            <span class="stat-label">Quality</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">GoHighLevel</span>
                            <span class="stat-label">Optimized</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">100%</span>
                            <span class="stat-label">Free Tool</span>
                        </div>
                    </div>
                </div>
                <div class="hero-visual">
                    <div class="hero-image">
                        <div class="floating-card card-1">
                            <span class="card-icon">📈</span>
                            <span class="card-text">Conversion</span>
                        </div>
                        <div class="floating-card card-2">
                            <span class="card-icon">⚡</span>
                            <span class="card-text">Fast</span>
                        </div>
                        <div class="floating-card card-3">
                            <span class="card-icon">🎯</span>
                            <span class="card-text">Optimized</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Tool Section -->
    <section class="tool-section">
        <div class="container">
            <div class="tool-card featured">
                <div class="tool-header">
                    <div class="tool-icon">📈</div>
                    <h2>Conversion Rate Optimizer</h2>
                    <p>Professional conversion optimization tool designed specifically for GoHighLevel users and agencies</p>
                </div>
                
                <div class="tool-interface">
                    <div class="input-group">
                        <label for="funnelType">Funnel Type</label>
                        <select id="funnelType">
                            <option value="">Select Funnel Type</option>
                            <option value="lead-generation">Lead Generation</option>
                            <option value="sales">Sales Funnel</option>
                            <option value="ecommerce">E-commerce</option>
                            <option value="webinar">Webinar/Event</option>
                            <option value="membership">Membership/Subscription</option>
                            <option value="custom">Custom Funnel</option>
                        </select>
                    </div>
                    
                    <div class="input-group">
                        <label for="currentConversionRate">Current Conversion Rate (%)</label>
                        <input type="number" id="currentConversionRate" placeholder="2.5" step="0.1" min="0" max="100">
                    </div>
                    
                    <div class="input-group">
                        <label for="monthlyTraffic">Monthly Traffic</label>
                        <input type="number" id="monthlyTraffic" placeholder="1000" min="0">
                    </div>
                    
                    <div class="input-group">
                        <label for="averageOrderValue">Average Order Value ($)</label>
                        <input type="number" id="averageOrderValue" placeholder="100" min="0" step="0.01">
                    </div>
                    
                    <div class="input-group">
                        <label for="targetConversionRate">Target Conversion Rate (%)</label>
                        <input type="number" id="targetConversionRate" placeholder="5.0" step="0.1" min="0" max="100">
                    </div>
                    
                    <div class="button-group">
                        <button class="btn btn-primary" onclick="analyzeConversionRates()">Analyze Conversion Rates</button>
                        <button class="btn btn-secondary" onclick="generateOptimizationPlan()">Generate Optimization Plan</button>
                        <button class="btn btn-secondary" onclick="clearResults()">Clear Results</button>
                    </div>
                    
                    <div class="result" id="conversionResult" style="display: none;">
                        <h3>Conversion Rate Analysis</h3>
                        <div class="metrics-grid" id="metricsGrid"></div>
                        <div class="recommendations" id="recommendations"></div>
                        <div class="optimization-actions">
                            <button class="btn btn-primary" onclick="exportReport()">Export Report</button>
                            <button class="btn btn-secondary" onclick="generateActionPlan()">Generate Action Plan</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Content Section -->
    <section class="content-section">
        <div class="container">
            <div class="content-grid">
                <article class="content-card">
                    <h2>What is Conversion Rate Optimization (CRO)?</h2>
                    <p>Conversion Rate Optimization (CRO) is the systematic process of improving the percentage of website visitors who take a desired action, such as making a purchase, filling out a form, or subscribing to a service. It involves analyzing user behavior, testing different elements, and implementing changes to increase conversions.</p>
                    
                    <p>For GoHighLevel users, CRO is crucial for:</p>
                    <ul>
                        <li><strong>Client Performance:</strong> Improving results for all client campaigns and funnels</li>
                        <li><strong>Revenue Growth:</strong> Increasing client revenue without increasing ad spend</li>
                        <li><strong>Competitive Advantage:</strong> Outperforming competitors with better conversion rates</li>
                        <li><strong>Client Retention:</strong> Demonstrating measurable value to retain clients</li>
                        <li><strong>Scalability:</strong> Growing client businesses through optimization</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Why GoHighLevel Users Need This Tool</h2>
                    <p>As a GoHighLevel agency, you're constantly working to improve client results and demonstrate value. Conversion rate optimization is one of the most effective ways to increase client success without requiring additional marketing budget.</p>
                    
                    <ul>
                        <li><strong>Data-Driven Decisions:</strong> Make optimization decisions based on actual performance data</li>
                        <li><strong>Client Success:</strong> Help clients achieve better results from existing traffic</li>
                        <li><strong>Revenue Optimization:</strong> Increase client revenue through better conversion rates</li>
                        <li><strong>Professional Expertise:</strong> Demonstrate advanced marketing knowledge and skills</li>
                        <li><strong>Competitive Positioning:</strong> Stand out as an agency that delivers measurable results</li>
                        <li><strong>Service Expansion:</strong> Add CRO as a premium service offering</li>
                        <li><strong>Client Retention:</strong> Keep clients longer by continuously improving performance</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>How to Use the Conversion Rate Optimizer</h2>
                    <p>Our conversion rate optimizer is designed to provide comprehensive analysis and actionable insights:</p>
                    
                    <ol>
                        <li><strong>Select Funnel Type:</strong> Choose the type of funnel you're optimizing</li>
                        <li><strong>Input Current Metrics:</strong> Enter your current conversion rate, traffic, and order value</li>
                        <li><strong>Set Target Goals:</strong> Define your target conversion rate for optimization</li>
                        <li><strong>Analyze Performance:</strong> Get detailed analysis of current vs. target performance</li>
                        <li><strong>Review Recommendations:</strong> Access specific optimization strategies and tactics</li>
                        <li><strong>Generate Action Plan:</strong> Create a step-by-step optimization roadmap</li>
                        <li><strong>Track Progress:</strong> Monitor improvements over time</li>
                    </ol>
                </article>

                <article class="content-card">
                    <h2>Use Cases for GoHighLevel Agencies</h2>
                    <p>This tool serves multiple purposes in your daily GoHighLevel operations:</p>
                    
                    <ul>
                        <li><strong>Client Performance Reviews:</strong> Analyze conversion rates during client meetings</li>
                        <li><strong>Campaign Optimization:</strong> Identify areas for improvement in active campaigns</li>
                        <li><strong>New Client Onboarding:</strong> Establish baseline metrics for new clients</li>
                        <li><strong>Service Proposals:</strong> Demonstrate potential improvements to prospects</li>
                        <li><strong>Funnel Audits:</strong> Conduct comprehensive funnel performance reviews</li>
                        <li><strong>ROI Improvement:</strong> Show clients how optimization increases their return</li>
                        <li><strong>Competitive Analysis:</strong> Compare performance against industry benchmarks</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Key Conversion Rate Metrics</h2>
                    <p>Understanding these metrics is essential for effective optimization:</p>
                    
                    <ul>
                        <li><strong>Conversion Rate:</strong> Percentage of visitors who complete desired actions</li>
                        <li><strong>Traffic Volume:</strong> Number of visitors to your funnel or landing page</li>
                        <li><strong>Conversion Value:</strong> Average value of each conversion</li>
                        <li><strong>Revenue per Visitor:</strong> Average revenue generated per visitor</li>
                        <li><strong>Conversion Funnel Drop-off:</strong> Where visitors abandon the process</li>
                        <li><strong>Time to Conversion:</strong> How long it takes visitors to convert</li>
                        <li><strong>Mobile vs. Desktop Performance:</strong> Conversion rates across devices</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Integration with GoHighLevel</h2>
                    <p>This tool integrates seamlessly with your GoHighLevel workflow:</p>
                    
                    <ul>
                        <li><strong>Funnel Analytics:</strong> Use conversion data from GHL funnel tracking</li>
                        <li><strong>Client Reporting:</strong> Include conversion analysis in client reports</li>
                        <li><strong>Campaign Management:</strong> Optimize campaigns based on conversion insights</li>
                        <li><strong>Automation Setup:</strong> Configure triggers based on conversion behavior</li>
                        <li><strong>Lead Scoring:</strong> Adjust lead scoring based on conversion patterns</li>
                        <li><strong>Email Sequences:</strong> Optimize email flows for better conversion rates</li>
                        <li><strong>Landing Page Design:</strong> Apply CRO principles to GHL landing pages</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Conversion Optimization Strategies</h2>
                    <p>Effective CRO involves multiple strategies working together:</p>
                    
                    <ul>
                        <li><strong>User Experience (UX) Optimization:</strong> Improve site navigation, speed, and usability</li>
                        <li><strong>Copy and Messaging:</strong> Test headlines, descriptions, and call-to-actions</li>
                        <li><strong>Design and Layout:</strong> Optimize visual elements and page structure</li>
                        <li><strong>Trust and Credibility:</strong> Add testimonials, reviews, and security badges</li>
                        <li><strong>Form Optimization:</strong> Simplify forms and reduce friction</li>
                        <li><strong>Mobile Optimization:</strong> Ensure mobile-friendly experience</li>
                        <li><strong>A/B Testing:</strong> Test different versions to find what works best</li>
                    </ul>
                </article>

                <article class="content-card">
                    <h2>Advanced CRO Techniques</h2>
                    <p>Beyond basic optimization, consider these advanced techniques:</p>
                    
                    <ul>
                        <li><strong>Multivariate Testing:</strong> Test multiple elements simultaneously</li>
                        <li><strong>Personalization:</strong> Customize experiences based on user behavior</li>
                        <li><strong>Behavioral Targeting:</strong> Show different content based on user actions</li>
                        <li><strong>Exit Intent Optimization:</strong> Capture users before they leave</li>
                        <li><strong>Social Proof Integration:</strong> Leverage social signals and testimonials</li>
                        <li><strong>Urgency and Scarcity:</strong> Create time-sensitive offers and limited availability</li>
                        <li><strong>Progressive Profiling:</strong> Collect information gradually over time</li>
                    </ul>
                </article>
            </div>
        </div>
    </section>

    <!-- Related Tools -->
    <section class="related-tools">
        <div class="container">
            <h2>Related GoHighLevel Tools</h2>
            <div class="tools-grid">
                <a href="funnel-calculator.php" class="tool-link">
                    <div class="tool-icon">📊</div>
                    <h3>Funnel Calculator</h3>
                    <p>Calculate funnel performance and ROI</p>
                </a>
                <a href="ab-testing.php" class="tool-link">
                    <div class="tool-icon">🧪</div>
                    <h3>A/B Testing Calculator</h3>
                    <p>Test different versions for better performance</p>
                </a>
                <a href="roi-calculator.php" class="tool-link">
                    <div class="tool-icon">💰</div>
                    <h3>ROI Calculator</h3>
                    <p>Calculate return on investment for campaigns</p>
                </a>
            </div>
        </div>
    </section>

    <?php inc('includes/footer.php'); ?>
    <script src="common.js"></script>
    <script>`n    `n    // Load footer`n    fetch("footer.php")`n        .then(response => response.text())`n        .then(data => {`n            document.getElementById("footer-placeholder").innerHTML = data;`n        });`n});`n`n
        // Conversion Rate Optimizer functionality
        function analyzeConversionRates() {
            const currentRate = parseFloat(document.getElementById('currentConversionRate').value) || 0;
            const monthlyTraffic = parseInt(document.getElementById('monthlyTraffic').value) || 0;
            const averageOrderValue = parseFloat(document.getElementById('averageOrderValue').value) || 0;
            const targetRate = parseFloat(document.getElementById('targetConversionRate').value) || 0;
            
            if (!currentRate || !monthlyTraffic || !averageOrderValue || !targetRate) {
                alert('Please fill in all fields');
                return;
            }
            
            // Calculate metrics
            const currentConversions = Math.round(monthlyTraffic * (currentRate / 100));
            const targetConversions = Math.round(monthlyTraffic * (targetRate / 100));
            const currentRevenue = currentConversions * averageOrderValue;
            const targetRevenue = targetConversions * averageOrderValue;
            const revenueIncrease = targetRevenue - currentRevenue;
            const conversionIncrease = targetConversions - currentConversions;
            
            // Calculate improvement percentage
            const improvementPercentage = ((targetRate - currentRate) / currentRate) * 100;
            
            displayResults({
                currentRate,
                targetRate,
                currentConversions,
                targetConversions,
                currentRevenue,
                targetRevenue,
                revenueIncrease,
                conversionIncrease,
                improvementPercentage,
                monthlyTraffic,
                averageOrderValue
            });
        }

        function displayResults(data) {
            const metricsGrid = document.getElementById('metricsGrid');
            const recommendations = document.getElementById('recommendations');
            
            // Display metrics
            metricsGrid.innerHTML = `
                <div class="metric-card">
                    <h4>Current Performance</h4>
                    <div class="metric-value">${data.currentRate.toFixed(2)}%</div>
                    <div class="metric-label">Conversion Rate</div>
                    <div class="metric-detail">${data.currentConversions} conversions</div>
                    <div class="metric-detail">$${data.currentRevenue.toLocaleString()}</div>
                </div>
                
                <div class="metric-card">
                    <h4>Target Performance</h4>
                    <div class="metric-value">${data.targetRate.toFixed(2)}%</div>
                    <div class="metric-label">Conversion Rate</div>
                    <div class="metric-detail">${data.targetConversions} conversions</div>
                    <div class="metric-detail">$${data.targetRevenue.toLocaleString()}</div>
                </div>
                
                <div class="metric-card highlight">
                    <h4>Potential Improvement</h4>
                    <div class="metric-value">+${data.improvementPercentage.toFixed(1)}%</div>
                    <div class="metric-label">Conversion Rate</div>
                    <div class="metric-detail">+${data.conversionIncrease} conversions</div>
                    <div class="metric-detail">+$${data.revenueIncrease.toLocaleString()}</div>
                </div>
            `;
            
            // Generate recommendations
            const recs = generateRecommendations(data);
            recommendations.innerHTML = `
                <h4>Optimization Recommendations</h4>
                <div class="recommendations-list">
                    ${recs.map(rec => `<div class="recommendation-item">${rec}</div>`).join('')}
                </div>
            `;
            
            document.getElementById('conversionResult').style.display = 'block';
        }

        function generateRecommendations(data) {
            const recommendations = [];
            
            // Industry-specific recommendations
            if (data.currentRate < 2) {
                recommendations.push("Focus on improving overall funnel conversion rates - aim for at least 2-5%");
            }
            
            if (data.improvementPercentage > 100) {
                recommendations.push("Set realistic improvement targets - aim for 20-50% improvement initially");
            }
            
            if (data.currentRate < 1) {
                recommendations.push("Address fundamental issues: improve page load speed, simplify forms, and enhance user experience");
            }
            
            if (data.currentRate >= 1 && data.currentRate < 3) {
                recommendations.push("Implement A/B testing for headlines, CTAs, and page layouts");
            }
            
            if (data.currentRate >= 3 && data.currentRate < 5) {
                recommendations.push("Focus on advanced optimization: personalization, behavioral targeting, and trust signals");
            }
            
            if (data.currentRate >= 5) {
                recommendations.push("Maintain high performance with continuous testing and optimization");
            }
            
            // Traffic-based recommendations
            if (data.monthlyTraffic < 1000) {
                recommendations.push("Increase traffic volume to get more reliable conversion data");
            }
            
            if (data.monthlyTraffic >= 1000 && data.monthlyTraffic < 5000) {
                recommendations.push("Implement conversion tracking and analytics for better insights");
            }
            
            if (data.monthlyTraffic >= 5000) {
                recommendations.push("Use advanced analytics and segmentation for targeted optimization");
            }
            
            // Revenue-based recommendations
            if (data.averageOrderValue < 50) {
                recommendations.push("Consider upselling and cross-selling strategies to increase order value");
            }
            
            if (data.averageOrderValue >= 50 && data.averageOrderValue < 200) {
                recommendations.push("Focus on value proposition and trust building for higher-value sales");
            }
            
            if (data.averageOrderValue >= 200) {
                recommendations.push("Implement high-touch sales processes and relationship building");
            }
            
            return recommendations.slice(0, 6); // Limit to 6 recommendations
        }

        function generateOptimizationPlan() {
            analyzeConversionRates();
        }

        function clearResults() {
            document.getElementById('conversionResult').style.display = 'none';
            document.getElementById('metricsGrid').innerHTML = '';
            document.getElementById('recommendations').innerHTML = '';
        }

        function exportReport() {
            const metricsGrid = document.getElementById('metricsGrid').innerHTML;
            const recommendations = document.getElementById('recommendations').innerHTML;
            
            const exportData = {
                timestamp: new Date().toISOString(),
                funnelType: document.getElementById('funnelType').value,
                currentRate: document.getElementById('currentConversionRate').value,
                targetRate: document.getElementById('targetConversionRate').value,
                monthlyTraffic: document.getElementById('monthlyTraffic').value,
                averageOrderValue: document.getElementById('averageOrderValue').value,
                metrics: metricsGrid,
                recommendations: recommendations
            };
            
            const dataStr = JSON.stringify(exportData, null, 2);
            const dataBlob = new Blob([dataStr], {type: 'application/json'});
            
            const link = document.createElement('a');
            link.href = URL.createObjectURL(dataBlob);
            link.download = 'conversion-rate-analysis.json';
            link.click();
        }

        function generateActionPlan() {
            const currentRate = parseFloat(document.getElementById('currentConversionRate').value) || 0;
            const targetRate = parseFloat(document.getElementById('targetConversionRate').value) || 0;
            
            if (!currentRate || !targetRate) {
                alert('Please analyze conversion rates first');
                return;
            }
            
            const improvementPercentage = ((targetRate - currentRate) / currentRate) * 100;
            
            let actionPlan = `# Conversion Rate Optimization Action Plan\n\n`;
            actionPlan += `## Current Status\n`;
            actionPlan += `- Current Conversion Rate: ${currentRate.toFixed(2)}%\n`;
            actionPlan += `- Target Conversion Rate: ${targetRate.toFixed(2)}%\n`;
            actionPlan += `- Required Improvement: ${improvementPercentage.toFixed(1)}%\n\n`;
            
            actionPlan += `## Phase 1: Foundation (Weeks 1-2)\n`;
            actionPlan += `- [ ] Audit current funnel performance\n`;
            actionPlan += `- [ ] Identify conversion bottlenecks\n`;
            actionPlan += `- [ ] Set up conversion tracking\n`;
            actionPlan += `- [ ] Establish baseline metrics\n\n`;
            
            actionPlan += `## Phase 2: Quick Wins (Weeks 3-4)\n`;
            actionPlan += `- [ ] Optimize page load speed\n`;
            actionPlan += `- [ ] Simplify forms and CTAs\n`;
            actionPlan += `- [ ] Improve mobile experience\n`;
            actionPlan += `- [ ] Add trust signals and testimonials\n\n`;
            
            actionPlan += `## Phase 3: Testing & Optimization (Weeks 5-8)\n`;
            actionPlan += `- [ ] Implement A/B testing\n`;
            actionPlan += `- [ ] Test headlines and copy\n`;
            actionPlan += `- [ ] Optimize page layouts\n`;
            actionPlan += `- [ ] Analyze user behavior\n\n`;
            
            actionPlan += `## Phase 4: Advanced Optimization (Weeks 9-12)\n`;
            actionPlan += `- [ ] Implement personalization\n`;
            actionPlan += `- [ ] Add behavioral targeting\n`;
            actionPlan += `- [ ] Optimize for different segments\n`;
            actionPlan += `- [ ] Continuous monitoring and improvement\n\n`;
            
            actionPlan += `## Success Metrics\n`;
            actionPlan += `- Target Conversion Rate: ${targetRate.toFixed(2)}%\n`;
            actionPlan += `- Monthly Goal: Achieve target rate consistently\n`;
            actionPlan += `- Quarterly Goal: Exceed target rate by 10%\n`;
            
            // Create and download action plan
            const dataBlob = new Blob([actionPlan], {type: 'text/markdown'});
            const link = document.createElement('a');
            link.href = URL.createObjectURL(dataBlob);
            link.download = 'conversion-optimization-action-plan.md';
            link.click();
        }

        // Industry benchmarks for different funnel types
        const industryBenchmarks = {
            'lead-generation': { low: 1, medium: 3, high: 5 },
            'sales': { low: 2, medium: 5, high: 8 },
            'ecommerce': { low: 1.5, medium: 3.5, high: 6 },
            'webinar': { low: 15, medium: 25, high: 35 },
            'membership': { low: 2, medium: 4, high: 7 },
            'custom': { low: 2, medium: 4, high: 6 }
        };

        // Update target rate suggestions based on funnel type
        document.getElementById('funnelType').addEventListener('change', function() {
            const funnelType = this.value;
            const benchmarks = industryBenchmarks[funnelType];
            
            if (benchmarks) {
                const targetInput = document.getElementById('targetConversionRate');
                targetInput.placeholder = `Target: ${benchmarks.medium}% (industry average)`;
                
                // Add helper text
                const helperText = document.createElement('small');
                helperText.textContent = `Industry benchmarks: Low: ${benchmarks.low}%, Medium: ${benchmarks.medium}%, High: ${benchmarks.high}%`;
                helperText.style.display = 'block';
                helperText.style.marginTop = '5px';
                helperText.style.color = '#666';
                
                const targetGroup = targetInput.parentElement;
                const existingHelper = targetGroup.querySelector('small');
                if (existingHelper) {
                    existingHelper.remove();
                }
                targetGroup.appendChild(helperText);
            }
        });
    </script>

    <style>
        .metrics-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin: 20px 0;
        }

        .metric-card {
            background: white;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .metric-card.highlight {
            border-color: #28a745;
            background: linear-gradient(135deg, #f8fff9 0%, #e8f5e8 100%);
        }

        .metric-card h4 {
            margin: 0 0 15px 0;
            color: #333;
            font-size: 16px;
        }

        .metric-value {
            font-size: 32px;
            font-weight: 700;
            color: #0a2038;
            margin-bottom: 5px;
        }

        .metric-label {
            font-size: 14px;
            color: #666;
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .metric-detail {
            font-size: 14px;
            color: #333;
            margin-bottom: 5px;
        }

        .recommendations {
            margin: 20px 0;
            padding: 20px;
            background: #f8f9fa;
            border-radius: 8px;
        }

        .recommendations h4 {
            margin: 0 0 15px 0;
            color: #333;
        }

        .recommendations-list {
            display: grid;
            gap: 10px;
        }

        .recommendation-item {
            background: white;
            padding: 15px;
            border-radius: 6px;
            border-left: 4px solid #0a2038;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .optimization-actions {
            margin-top: 20px;
            text-align: center;
        }

        .optimization-actions .btn {
            margin: 0 10px;
        }
    </style>
</body>
</html>




