<?php
// Site Configuration
define('SITE_NAME', 'GHL Toolset');
define('BASE_URL', 'https://ghltoolset.com');

// AdSense Configuration
define('ADSENSE_PUB', 'ca-pub-4394802611566771');
define('ENABLE_ADS', true);
define('AD_FREQUENCY_CAP_HOURS', 24);

// Analytics Configuration
define('GA4_ID', 'G-CC2D6HTK5T');
define('ENABLE_ANALYTICS', true);

// Paddle CRM Configuration
define('BOOKING_URL', 'https://platform.paddlecrm.com/demos');

// UTM Defaults
define('DEFAULT_UTM_SOURCE', 'ghl-toolset');
define('DEFAULT_UTM_MEDIUM', 'site');

// Security & Performance
define('ENABLE_SECURITY_HEADERS', true);
define('ENABLE_COMPRESSION', true);
define('CACHE_MAX_AGE', 31536000); // 1 year for static assets

// Environment Configuration
define('ENV', 'prod'); // Change to 'prod' for production
if (ENV === 'dev') {
    ini_set('display_errors', 1);
    error_reporting(E_ALL);
}

// Feature Flags for World-Class Upgrade
define('HERO_MINIMAL', false);        // keep icons; refine visuals
define('SHOW_TOP_ADS', false);        // no top ads
define('ENABLE_AFFILIATE_PANELS', true);
define('ENABLE_GHL_AFFILIATE_CARD', true);

// Path helpers
define('ROOT', str_replace('\\', '/', __DIR__));
define('BASE_PATH', '/'); // if in subfolder, e.g. '/ghl-tools/'

/**
 * Generate URL with proper base path
 */
function url(string $path = ''): string {
    return rtrim(BASE_PATH, '/') . '/' . ltrim($path, '/');
}

/**
 * Include file with proper path resolution
 */
function inc(string $relativePath): void {
    require_once ROOT . '/' . ltrim($relativePath, '/');
}
?>
