<?php
// Load configuration
require_once dirname(__DIR__) . '/config.php';
inc('includes/seo.php');
inc('includes/cta.php');

// Page metadata
$pageTitle = optimize_title('Free GHL Audit - Get Your GoHighLevel Setup Reviewed');
$pageDescription = optimize_description('Get a free professional audit of your GoHighLevel setup. Our experts will identify issues, optimization opportunities, and provide a custom improvement roadmap.');
$canonicalUrl = get_canonical_url('audit');

// Schema data
$toolSchema = get_tool_schema(
    'GHL Audit Service',
    'Professional GoHighLevel setup audit and optimization service',
    $canonicalUrl,
    [
        'Account configuration review',
        'Pipeline optimization analysis', 
        'Automation workflow audit',
        'Integration assessment',
        'Performance optimization recommendations',
        'Custom improvement roadmap'
    ]
);

$faqSchema = get_faq_schema([
    [
        'question' => 'What does the GHL audit include?',
        'answer' => 'Our comprehensive audit covers your account configuration, pipeline setup, automation workflows, integrations, and performance metrics. You\'ll receive a detailed report with specific recommendations and a prioritized action plan.'
    ],
    [
        'question' => 'How long does the audit take?',
        'answer' => 'The initial audit call takes 30-45 minutes. You\'ll receive your detailed audit report within 24-48 hours, followed by a 30-minute results review call.'
    ],
    [
        'question' => 'Is this really free?',
        'answer' => 'Yes, completely free. We provide genuine value upfront to demonstrate our expertise. There\'s no obligation to purchase additional services.'
    ],
    [
        'question' => 'What if I\'m already working with another agency?',
        'answer' => 'No problem. Our audit is independent and focuses on your GHL setup, not your agency relationship. Many clients use our findings to improve their current setup or get better results from their existing agency.'
    ],
    [
        'question' => 'Do you work with all industries?',
        'answer' => 'Yes, we have experience across real estate, home services, e-commerce, professional services, and many other industries. Our audit methodology applies to any business using GoHighLevel.'
    ]
]);

$breadcrumbs = [
    ['name' => 'Home', 'url' => get_canonical_url()],
    ['name' => 'Free GHL Audit', 'url' => $canonicalUrl]
];
$breadcrumbSchema = get_breadcrumb_schema($breadcrumbs);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <?php 
    render_meta($pageTitle, $pageDescription, $canonicalUrl);
    render_schema($toolSchema);
    render_schema($faqSchema);
    render_schema($breadcrumbSchema);
    render_preconnects();
    ?>
    
    <link rel="stylesheet" href="../public/css/tokens.css">
    <link rel="stylesheet" href="../styles.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Page-specific JavaScript configuration -->
    <script>
        window.GA4_ID = '<?php echo GA4_ID; ?>';
        window.ADSENSE_PUB = '<?php echo ADSENSE_PUB; ?>';
        window.pageLoadTime = Date.now();
    </script>
</head>
<body>
    <a href="#main-content" class="skip-to-content">Skip to content</a>
    
    <?php inc('includes/header.php'); ?>
    
    <main id="main-content">
        <!-- Hero Section -->
        <section class="hero audit-hero">
            <div class="container">
                <div class="hero-content">
                    <div class="hero-badge">
                        <span class="badge badge-success">✓ 100% Free</span>
                        <span class="badge badge-info">⚡ 48-Hour Turnaround</span>
                    </div>
                    
                    <h1 class="hero-title">
                        Get Your <span class="highlight">GoHighLevel Setup</span> 
                        Professionally Audited
                    </h1>
                    
                    <p class="hero-subtitle">
                        Find hidden issues, missed opportunities, and get a clear roadmap to maximize 
                        your GHL investment. Most audits reveal $5,000+ in lost revenue potential.
                    </p>
                    
                    <div class="hero-stats">
                        <div class="stat-item">
                            <span class="stat-number">200+</span>
                            <span class="stat-label">Audits Completed</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">89%</span>
                            <span class="stat-label">Find Critical Issues</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">$5,000+</span>
                            <span class="stat-label">Avg. Value Identified</span>
                        </div>
                    </div>
                </div>
                
                <!-- Audit Form -->
                <div class="audit-form-container">
                    <div class="audit-form-card">
                        <div class="form-header">
                            <h2>Book Your Free Audit</h2>
                            <p>Takes 2 minutes. No spam, ever.</p>
                        </div>
                        
                        <form id="audit-form" class="audit-form" novalidate>
                            <div class="form-group">
                                <label for="full_name">Full Name *</label>
                                <input type="text" id="full_name" name="full_name" required 
                                       placeholder="Enter your full name">
                                <div class="form-error" role="alert"></div>
                            </div>
                            
                            <div class="form-group">
                                <label for="email">Email Address *</label>
                                <input type="email" id="email" name="email" required 
                                       placeholder="your.email@company.com">
                                <div class="form-error" role="alert"></div>
                            </div>
                            
                            <div class="form-group">
                                <label for="company">Company/Business Name</label>
                                <input type="text" id="company" name="company" 
                                       placeholder="Your business name">
                                <div class="form-error" role="alert"></div>
                            </div>
                            
                            <div class="form-group">
                                <label for="ghl_experience">GHL Experience *</label>
                                <select id="ghl_experience" name="ghl_experience" required>
                                    <option value="">Select your experience level</option>
                                    <option value="new">New to GHL (0-3 months)</option>
                                    <option value="beginner">Beginner (3-12 months)</option>
                                    <option value="intermediate">Intermediate (1-2 years)</option>
                                    <option value="advanced">Advanced (2+ years)</option>
                                </select>
                                <div class="form-error" role="alert"></div>
                            </div>
                            
                            <div class="form-group">
                                <label for="biggest_challenge">Biggest GHL Challenge *</label>
                                <select id="biggest_challenge" name="biggest_challenge" required>
                                    <option value="">What's your main challenge?</option>
                                    <option value="setup">Initial setup and configuration</option>
                                    <option value="automation">Automation not working properly</option>
                                    <option value="integrations">Integration issues</option>
                                    <option value="lead_gen">Not generating enough leads</option>
                                    <option value="conversion">Low conversion rates</option>
                                    <option value="reporting">Poor reporting/tracking</option>
                                    <option value="team_adoption">Team not using it properly</option>
                                    <option value="roi">Not seeing ROI from GHL</option>
                                    <option value="other">Other/Multiple issues</option>
                                </select>
                                <div class="form-error" role="alert"></div>
                            </div>
                            
                            <div class="form-group">
                                <label for="monthly_leads">Monthly Lead Volume</label>
                                <select id="monthly_leads" name="monthly_leads">
                                    <option value="">Select monthly lead volume</option>
                                    <option value="0-50">0-50 leads</option>
                                    <option value="50-200">50-200 leads</option>
                                    <option value="200-500">200-500 leads</option>
                                    <option value="500-1000">500-1,000 leads</option>
                                    <option value="1000+">1,000+ leads</option>
                                </select>
                                <div class="form-error" role="alert"></div>
                            </div>
                            
                            <button type="submit" class="btn btn-primary btn-lg btn-full-width" 
                                    id="submit-btn">
                                <span class="btn-text">Book My Free Audit</span>
                                <span class="btn-loading" style="display: none;">Booking...</span>
                            </button>
                            
                            <div class="form-disclaimer">
                                <small>
                                    By submitting this form, you agree to receive communications from Paddle CRM. 
                                    We respect your privacy and never share your information.
                                    <a href="../legal/privacy.php">Privacy Policy</a>
                                </small>
                            </div>
                        </form>
                        
                        <div class="trust-indicators">
                            <div class="trust-item">
                                <span class="trust-icon">🔒</span>
                                <span class="trust-text">Your data is secure</span>
                            </div>
                            <div class="trust-item">
                                <span class="trust-icon">✅</span>
                                <span class="trust-text">No obligation</span>
                            </div>
                            <div class="trust-item">
                                <span class="trust-icon">⚡</span>
                                <span class="trust-text">Fast response</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- What's Included Section -->
        <section class="audit-included">
            <div class="container">
                <div class="section-header">
                    <h2>What's Included In Your Free Audit</h2>
                    <p>A comprehensive 60+ point inspection of your GoHighLevel setup</p>
                </div>
                
                <div class="audit-grid">
                    <div class="audit-item">
                        <div class="audit-icon">🔍</div>
                        <h3>Account Configuration Review</h3>
                        <p>We'll examine your account structure, user permissions, and basic settings to ensure optimal configuration.</p>
                    </div>
                    
                    <div class="audit-item">
                        <div class="audit-icon">🚀</div>
                        <h3>Pipeline & Funnel Analysis</h3>
                        <p>Deep dive into your sales pipelines, conversion rates, and funnel performance to identify bottlenecks.</p>
                    </div>
                    
                    <div class="audit-item">
                        <div class="audit-icon">⚙️</div>
                        <h3>Automation Workflow Audit</h3>
                        <p>Review all automations for logical errors, missing triggers, and optimization opportunities.</p>
                    </div>
                    
                    <div class="audit-item">
                        <div class="audit-icon">🔗</div>
                        <h3>Integration Assessment</h3>
                        <p>Check all third-party integrations for proper setup, data flow, and potential improvements.</p>
                    </div>
                    
                    <div class="audit-item">
                        <div class="audit-icon">📊</div>
                        <h3>Reporting & Analytics</h3>
                        <p>Evaluate your tracking setup, custom fields, and reporting to ensure you're measuring what matters.</p>
                    </div>
                    
                    <div class="audit-item">
                        <div class="audit-icon">💡</div>
                        <h3>Custom Improvement Plan</h3>
                        <p>Receive a prioritized action plan with specific recommendations and implementation guidance.</p>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- How It Works -->
        <section class="how-it-works">
            <div class="container">
                <div class="section-header">
                    <h2>How The Audit Process Works</h2>
                    <p>Simple, fast, and completely free</p>
                </div>
                
                <div class="process-steps">
                    <div class="process-step">
                        <div class="step-number">1</div>
                        <div class="step-content">
                            <h3>Book Your Call</h3>
                            <p>Fill out the form above and we'll schedule a 30-45 minute screen-sharing session within 24 hours.</p>
                        </div>
                    </div>
                    
                    <div class="process-step">
                        <div class="step-number">2</div>
                        <div class="step-content">
                            <h3>Live Audit Session</h3>
                            <p>We'll review your GHL account together, asking questions and documenting findings in real-time.</p>
                        </div>
                    </div>
                    
                    <div class="process-step">
                        <div class="step-number">3</div>
                        <div class="step-content">
                            <h3>Detailed Report</h3>
                            <p>Within 48 hours, receive a comprehensive audit report with findings, recommendations, and action items.</p>
                        </div>
                    </div>
                    
                    <div class="process-step">
                        <div class="step-number">4</div>
                        <div class="step-content">
                            <h3>Results Review</h3>
                            <p>30-minute follow-up call to review findings, answer questions, and discuss implementation priorities.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- FAQ Section -->
        <section class="faq-section">
            <div class="container">
                <div class="section-header">
                    <h2>Frequently Asked Questions</h2>
                </div>
                
                <div class="faq-grid">
                    <div class="faq-item">
                        <h3 class="faq-question">What does the GHL audit include?</h3>
                        <div class="faq-answer">
                            <p>Our comprehensive audit covers your account configuration, pipeline setup, automation workflows, integrations, and performance metrics. You'll receive a detailed report with specific recommendations and a prioritized action plan.</p>
                        </div>
                    </div>
                    
                    <div class="faq-item">
                        <h3 class="faq-question">How long does the audit take?</h3>
                        <div class="faq-answer">
                            <p>The initial audit call takes 30-45 minutes. You'll receive your detailed audit report within 24-48 hours, followed by a 30-minute results review call.</p>
                        </div>
                    </div>
                    
                    <div class="faq-item">
                        <h3 class="faq-question">Is this really free?</h3>
                        <div class="faq-answer">
                            <p>Yes, completely free. We provide genuine value upfront to demonstrate our expertise. There's no obligation to purchase additional services.</p>
                        </div>
                    </div>
                    
                    <div class="faq-item">
                        <h3 class="faq-question">What if I'm already working with another agency?</h3>
                        <div class="faq-answer">
                            <p>No problem. Our audit is independent and focuses on your GHL setup, not your agency relationship. Many clients use our findings to improve their current setup or get better results from their existing agency.</p>
                        </div>
                    </div>
                    
                    <div class="faq-item">
                        <h3 class="faq-question">Do you work with all industries?</h3>
                        <div class="faq-answer">
                            <p>Yes, we have experience across real estate, home services, e-commerce, professional services, and many other industries. Our audit methodology applies to any business using GoHighLevel.</p>
                        </div>
                    </div>
                    
                    <div class="faq-item">
                        <h3 class="faq-question">What happens after the audit?</h3>
                        <div class="faq-answer">
                            <p>You'll have everything you need to implement improvements yourself. If you'd like help with implementation, we can discuss our done-for-you services, but there's absolutely no pressure.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        <!-- Final CTA -->
        <?php render_cta(null, ['placement' => 'footer', 'show_image' => true]); ?>
        
        <!-- Exit Intent Modal -->
        <?php render_exit_intent_cta(); ?>
    </main>
    
    <?php inc('includes/footer.php'); ?>
    
    <!-- JavaScript -->
    <script src="../lib/js/consent.js"></script>
    <script src="../lib/js/analytics.js"></script>
    
    <script>
        // Form handling
        document.getElementById('audit-form').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const form = e.target;
            const submitBtn = document.getElementById('submit-btn');
            const btnText = submitBtn.querySelector('.btn-text');
            const btnLoading = submitBtn.querySelector('.btn-loading');
            
            // Clear previous errors
            form.querySelectorAll('.form-error').forEach(error => {
                error.textContent = '';
                error.parentElement.classList.remove('has-error');
            });
            
            // Validate form
            const formData = new FormData(form);
            const data = Object.fromEntries(formData);
            
            const errors = validateForm(data);
            if (Object.keys(errors).length > 0) {
                displayFormErrors(errors);
                return;
            }
            
            // Show loading state
            submitBtn.disabled = true;
            btnText.style.display = 'none';
            btnLoading.style.display = 'inline';
            
            try {
                // Track form submission
                track('form_submit', {
                    form_type: 'audit_request',
                    ghl_experience: data.ghl_experience,
                    biggest_challenge: data.biggest_challenge,
                    monthly_leads: data.monthly_leads
                });
                
                // Add UTM parameters and redirect to Paddle CRM
                const urlParams = new URLSearchParams({
                    utm_source: 'ghl-toolset',
                    utm_medium: 'audit-form',
                    utm_campaign: 'audit',
                    name: data.full_name,
                    email: data.email,
                    company: data.company || '',
                    experience: data.ghl_experience,
                    challenge: data.biggest_challenge,
                    leads: data.monthly_leads || ''
                });
                
                // Track conversion
                track('conversion', {
                    conversion_type: 'audit_request',
                    conversion_value: 2000, // Estimated value of audit
                    form_data: data
                });
                
                // Redirect to Paddle CRM booking with pre-filled data
                window.open('<?php echo BOOKING_URL; ?>?' + urlParams.toString(), '_blank');
                
                // Show success message
                showSuccessMessage();
                
            } catch (error) {
                console.error('Form submission error:', error);
                showErrorMessage('Something went wrong. Please try again or contact us directly.');
                
                // Track error
                trackError(error, { form_data: data });
            } finally {
                // Reset button state
                submitBtn.disabled = false;
                btnText.style.display = 'inline';
                btnLoading.style.display = 'none';
            }
        });
        
        function validateForm(data) {
            const errors = {};
            
            if (!data.full_name || data.full_name.trim().length < 2) {
                errors.full_name = 'Please enter your full name';
            }
            
            if (!data.email || !isValidEmail(data.email)) {
                errors.email = 'Please enter a valid email address';
            }
            
            if (!data.ghl_experience) {
                errors.ghl_experience = 'Please select your GHL experience level';
            }
            
            if (!data.biggest_challenge) {
                errors.biggest_challenge = 'Please select your biggest challenge';
            }
            
            return errors;
        }
        
        function isValidEmail(email) {
            return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
        }
        
        function displayFormErrors(errors) {
            Object.keys(errors).forEach(field => {
                const input = document.getElementById(field);
                const errorDiv = input.nextElementSibling;
                
                input.parentElement.classList.add('has-error');
                errorDiv.textContent = errors[field];
                
                // Focus first error field
                if (Object.keys(errors)[0] === field) {
                    input.focus();
                }
            });
        }
        
        function showSuccessMessage() {
            const form = document.getElementById('audit-form');
            form.innerHTML = `
                <div class="success-message">
                    <div class="success-icon">✅</div>
                    <h3>Booking Window Opened!</h3>
                    <p>Please complete your booking in the new window. If it didn't open, 
                       <a href="<?php echo BOOKING_URL; ?>" target="_blank">click here</a>.</p>
                    <p>You'll receive a confirmation email with next steps within a few minutes.</p>
                </div>
            `;
        }
        
        function showErrorMessage(message) {
            const form = document.getElementById('audit-form');
            const errorDiv = document.createElement('div');
            errorDiv.className = 'form-error-message';
            errorDiv.textContent = message;
            form.insertBefore(errorDiv, form.firstChild);
            
            setTimeout(() => errorDiv.remove(), 5000);
        }
        
        // FAQ accordion
        document.querySelectorAll('.faq-question').forEach(question => {
            question.addEventListener('click', function() {
                const item = this.parentElement;
                const answer = item.querySelector('.faq-answer');
                const isOpen = item.classList.contains('open');
                
                // Close all other items
                document.querySelectorAll('.faq-item').forEach(otherItem => {
                    if (otherItem !== item) {
                        otherItem.classList.remove('open');
                    }
                });
                
                // Toggle current item
                item.classList.toggle('open', !isOpen);
            });
        });
        
        // Track page engagement
        track('page_view', {
            page_type: 'audit_landing',
            referrer: document.referrer
        });
    </script>
    
    <style>
        /* Audit-specific styles */
        .audit-hero {
            background: linear-gradient(135deg, var(--color-primary-50) 0%, var(--color-primary-100) 100%);
            padding: var(--space-20) 0;
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: var(--space-16);
            align-items: center;
        }
        
        .hero-badge {
            display: flex;
            gap: var(--space-3);
            margin-bottom: var(--space-6);
        }
        
        .badge {
            padding: var(--space-2) var(--space-4);
            border-radius: var(--radius-full);
            font-size: var(--font-size-sm);
            font-weight: var(--font-weight-medium);
        }
        
        .badge-success {
            background: var(--color-success);
            color: white;
        }
        
        .badge-info {
            background: var(--color-info);
            color: white;
        }
        
        .audit-form-container {
            background: white;
            border-radius: var(--radius-2xl);
            box-shadow: var(--shadow-2xl);
            overflow: hidden;
        }
        
        .audit-form-card {
            padding: var(--space-8);
        }
        
        .form-header {
            text-align: center;
            margin-bottom: var(--space-8);
        }
        
        .form-header h2 {
            margin-bottom: var(--space-2);
            font-size: var(--font-size-2xl);
        }
        
        .form-group {
            margin-bottom: var(--space-6);
        }
        
        .form-group label {
            display: block;
            margin-bottom: var(--space-2);
            font-weight: var(--font-weight-medium);
            color: var(--color-neutral-700);
        }
        
        .form-group input,
        .form-group select {
            width: 100%;
            padding: var(--form-input-padding-y) var(--form-input-padding-x);
            border: var(--form-input-border);
            border-radius: var(--form-input-border-radius);
            font-size: var(--font-size-base);
            transition: var(--transition-base);
        }
        
        .form-group input:focus,
        .form-group select:focus {
            outline: none;
            border-color: var(--form-input-focus-border);
            box-shadow: var(--form-input-focus-ring);
        }
        
        .form-group.has-error input,
        .form-group.has-error select {
            border-color: var(--color-error);
        }
        
        .form-error {
            color: var(--color-error);
            font-size: var(--font-size-sm);
            margin-top: var(--space-1);
        }
        
        .btn-full-width {
            width: 100%;
            justify-content: center;
        }
        
        .form-disclaimer {
            text-align: center;
            margin-top: var(--space-4);
            color: var(--color-neutral-500);
        }
        
        .trust-indicators {
            display: flex;
            justify-content: center;
            gap: var(--space-6);
            margin-top: var(--space-6);
            padding-top: var(--space-6);
            border-top: 1px solid var(--color-neutral-200);
        }
        
        .trust-item {
            display: flex;
            align-items: center;
            gap: var(--space-2);
            font-size: var(--font-size-sm);
            color: var(--color-neutral-600);
        }
        
        .audit-included,
        .how-it-works,
        .faq-section {
            padding: var(--space-20) 0;
        }
        
        .section-header {
            text-align: center;
            margin-bottom: var(--space-16);
        }
        
        .section-header h2 {
            font-size: var(--font-size-4xl);
            margin-bottom: var(--space-4);
        }
        
        .audit-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: var(--space-8);
        }
        
        .audit-item {
            text-align: center;
            padding: var(--space-6);
        }
        
        .audit-icon {
            font-size: var(--font-size-5xl);
            margin-bottom: var(--space-4);
        }
        
        .process-steps {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: var(--space-8);
        }
        
        .process-step {
            text-align: center;
        }
        
        .step-number {
            width: 60px;
            height: 60px;
            background: var(--color-primary-500);
            color: white;
            border-radius: var(--radius-full);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: var(--font-size-2xl);
            font-weight: var(--font-weight-bold);
            margin: 0 auto var(--space-4);
        }
        
        .faq-grid {
            max-width: 800px;
            margin: 0 auto;
        }
        
        .faq-item {
            border-bottom: 1px solid var(--color-neutral-200);
            padding: var(--space-6) 0;
        }
        
        .faq-question {
            cursor: pointer;
            margin: 0;
            font-size: var(--font-size-lg);
            color: var(--color-neutral-900);
        }
        
        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height var(--transition-base);
        }
        
        .faq-item.open .faq-answer {
            max-height: 200px;
            margin-top: var(--space-4);
        }
        
        .success-message {
            text-align: center;
            padding: var(--space-8);
        }
        
        .success-icon {
            font-size: var(--font-size-5xl);
            margin-bottom: var(--space-4);
        }
        
        .form-error-message {
            background: var(--color-error);
            color: white;
            padding: var(--space-4);
            border-radius: var(--radius-base);
            margin-bottom: var(--space-4);
        }
        
        @media (max-width: 768px) {
            .audit-hero {
                grid-template-columns: 1fr;
                text-align: center;
            }
            
            .trust-indicators {
                flex-direction: column;
                align-items: center;
            }
        }
    </style>
</body>
</html>